/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.hopeclinic.gestiondespatients.controller.AuthController;
import org.hopeclinic.gestiondespatients.model.Assurance;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Chambre;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Examen;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Rdv;
import org.hopeclinic.gestiondespatients.model.Role;
import org.hopeclinic.gestiondespatients.model.Service;
import org.hopeclinic.gestiondespatients.model.Soin;
import org.hopeclinic.gestiondespatients.model.Symptome;
import org.hopeclinic.gestiondespatients.model.TypeSoin;
import org.hopeclinic.gestiondespatients.repository.ActeRepository;
import org.hopeclinic.gestiondespatients.repository.AntecedentRepository;
import org.hopeclinic.gestiondespatients.repository.AssuranceRepository;
import org.hopeclinic.gestiondespatients.repository.BonExamenRepository;
import org.hopeclinic.gestiondespatients.repository.ChambreRepository;
import org.hopeclinic.gestiondespatients.repository.ConsultationRepository;
import org.hopeclinic.gestiondespatients.repository.DossierMedicalRepository;
import org.hopeclinic.gestiondespatients.repository.ExamenRepository;
import org.hopeclinic.gestiondespatients.repository.FactureRepository;
import org.hopeclinic.gestiondespatients.repository.HospitalisationRepository;
import org.hopeclinic.gestiondespatients.repository.PatientRepository;
import org.hopeclinic.gestiondespatients.repository.PersonnelMedicalRepository;
import org.hopeclinic.gestiondespatients.repository.RdvRepository;
import org.hopeclinic.gestiondespatients.repository.RecuRepository;
import org.hopeclinic.gestiondespatients.repository.RoleRepository;
import org.hopeclinic.gestiondespatients.repository.ServiceRepository;
import org.hopeclinic.gestiondespatients.repository.SoinRepository;
import org.hopeclinic.gestiondespatients.repository.SymptomeRepository;
import org.hopeclinic.gestiondespatients.repository.TypeSoinRepository;
import org.hopeclinic.gestiondespatients.type.EtatFacture;
import org.hopeclinic.gestiondespatients.type.EtatOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class DatabaseLoader
implements CommandLineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AuthController.class);
    private final PatientRepository patients;
    private final DossierMedicalRepository dossiersMedicaux;
    private final AssuranceRepository assurances;
    private final ServiceRepository services;
    private final PersonnelMedicalRepository personnelsMedicaux;
    private final ConsultationRepository consultations;
    private final ExamenRepository examens;
    private final HospitalisationRepository hospitalisations;
    private final TypeSoinRepository typesSoins;
    private final SoinRepository soins;
    private final ActeRepository actes;
    private final FactureRepository factures;
    private final RecuRepository recus;
    private final BonExamenRepository bonExamens;
    private final RoleRepository roles;
    private final RdvRepository rdv;
    private final ChambreRepository chambres;
    private final SymptomeRepository symptomes;
    private final AntecedentRepository antecedents;

    @Autowired
    public DatabaseLoader(PatientRepository patients, RoleRepository roles, AssuranceRepository assurances, ServiceRepository services, HospitalisationRepository hospitalisations, SoinRepository soins, ExamenRepository examens, TypeSoinRepository typesSoins, ActeRepository actes, FactureRepository factures, RecuRepository recus, ConsultationRepository consultations, PersonnelMedicalRepository personnelsMedicaux, DossierMedicalRepository dossiersMedicaux, BonExamenRepository bonExamens, AntecedentRepository antecedents, RdvRepository rdv, ChambreRepository chambres, SymptomeRepository symptomes) {
        this.patients = patients;
        this.roles = roles;
        this.typesSoins = typesSoins;
        this.soins = soins;
        this.actes = actes;
        this.rdv = rdv;
        this.chambres = chambres;
        this.factures = factures;
        this.recus = recus;
        this.personnelsMedicaux = personnelsMedicaux;
        this.consultations = consultations;
        this.assurances = assurances;
        this.examens = examens;
        this.services = services;
        this.hospitalisations = hospitalisations;
        this.dossiersMedicaux = dossiersMedicaux;
        this.bonExamens = bonExamens;
        this.antecedents = antecedents;
        this.symptomes = symptomes;
    }

    private void initDB() throws Exception {
        Date tomorowDate = new Date();
        Date yesterdayDate = new Date();
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(tomorowDate);
        c2.setTime(yesterdayDate);
        c1.add(5, 2);
        c2.add(5, -1);
        tomorowDate = c1.getTime();
        yesterdayDate = c2.getTime();
        Role admin = (Role)this.roles.save(new Role(null, "Admin", null, null, null));
        Role dga = (Role)this.roles.save(new Role(null, "Dga", null, null, null));
        Role daf = (Role)this.roles.save(new Role(null, "Daf", null, null, null));
        Role medecin = (Role)this.roles.save(new Role(null, "Medecin", null, null, null));
        Role infirmier = (Role)this.roles.save(new Role(null, "Infirmier", null, null, null));
        Role caissier = (Role)this.roles.save(new Role(null, "Caissier", null, null, null));
        Role secretaire = (Role)this.roles.save(new Role(null, "Secretaire", null, null, null));
        this.services.save(new Service(null, "Cardiologie", null, 25000.0, null, null, null, null, null, null, null, null, null));
        this.services.save(new Service(null, "P\u00e9diatrie", null, 15000.0, null, null, null, null, null, null, null, null, null));
        Service gynecologie = (Service)this.services.save(new Service(null, "Gyn\u00e9cologie", null, 20000.0, null, null, null, null, null, null, null, null, null));
        this.assurances.save(new Assurance(null, "Axa", "AXA Gabon est une filiale du Groupe AXA, 1\u00e8re marque mondiale de l\u2019assurance pour la 10\u00e8me ann\u00e9e cons\u00e9cutive.", "axa_assurance.jpg", 3, null, null, null, null));
        this.assurances.save(new Assurance(null, "Cnamgs", "l\u2019am\u00e9lioration de l\u2019acc\u00e8s aux soins de sant\u00e9", "cnamgs_assurance.png", 4, null, null, null, null));
        this.assurances.save(new Assurance(null, "Sunu", "2\u00e8me compagnie Vie du march\u00e9 gabonais avec plus de 22 milliards de FCFA d\u2019actifs g\u00e9r\u00e9s.", "sunu_assurance.jpg", 3, null, null, null, null));
        PersonnelMedical medecin2 = (PersonnelMedical)this.personnelsMedicaux.save(new PersonnelMedical(null, "ane", "Ella", "Ane", "F", new GregorianCalendar(1990, 6, 22).getTime(), "IAI, Libreville", "077541577", "aneell@gmail.com", "ane1234", null, null, null, null, medecin, gynecologie, null, null, null));
        PersonnelMedical infirmier1 = (PersonnelMedical)this.personnelsMedicaux.save(new PersonnelMedical(null, "infirmier", "Obone", "Sarah", "F", new GregorianCalendar(1998, 1, 11).getTime(), "Nzeng Ayong, Libreville", "066332211", "sarahobo@gmail.com", "infirmier1234", null, null, null, null, infirmier, gynecologie, null, null, null));
        this.personnelsMedicaux.save(new PersonnelMedical(null, "secretaire", "Ndong", "Marie", "F", new GregorianCalendar(1988, 0, 8).getTime(), "Nzeng Ayong, Libreville", "063392211", "marieobo@gmail.com", "secretaire1234", null, null, null, null, secretaire, null, null, null, null));
        this.personnelsMedicaux.save(new PersonnelMedical(null, "caissier", "Essome", "Zach", "M", new GregorianCalendar(1995, 4, 3).getTime(), "Delta, Akanda", "074333333", "zachess@gmail.com", "caissier1234", null, null, null, null, caissier, null, null, null, null));
        this.personnelsMedicaux.save(new PersonnelMedical(null, "dga", "Ekomie", "Zach", "M", new GregorianCalendar(1985, 8, 9).getTime(), "Okala, Akanda", "074558811", "deboraeko@gmail.com", "dga1234", null, null, null, null, dga, null, null, null, null));
        this.personnelsMedicaux.save(new PersonnelMedical(null, "daf", "Nang", "Sylvie", "F", new GregorianCalendar(1980, 1, 2).getTime(), "Nzeng Ayong, Libreville", "077443322", "sylvienan@gmail.com", "daf1234", null, null, null, null, daf, null, null, null, null));
        this.personnelsMedicaux.save(new PersonnelMedical(null, "lydie", "Yougang", "Adrielle", "F", new GregorianCalendar(1992, 7, 7).getTime(), "Okala, Akanda", "074663322", "adrielle@gmail.com", "lydie1234", null, null, null, null, admin, null, null, null, null));
        Patient patient1 = (Patient)this.patients.save(new Patient(null, "luc", "Abessolo", "Luc", "M", new GregorianCalendar(1990, 10, 1).getTime(), "Owendo, Libreville", "074004859", "Enseignant", "lucabe@gmail.com", "luc1234", "Yvan Bekale", "Fr\u00e8re", "Agent Immobilier", "077987654", "Charbonnages, Libreville", null, null, null, null));
        Patient patient2 = (Patient)this.patients.save(new Patient(null, "ruth", "Obame", "Ruth", "F", new GregorianCalendar(1995, 11, 21).getTime(), "Charbonnages, Libreville", "077405060", "Etudiante", "ruthoba@gmail.com", "ruth1234", "Josiane Mengue", "Soeur", "Pharmacienne", "066987654", "Mindoumbe, Libreville", null, null, null, null));
        DossierMedical dossierMedicalPatient1 = (DossierMedical)this.dossiersMedicaux.save(new DossierMedical(null, "A +", "AA", null, null, patient1, null, null, null, null, null));
        DossierMedical dossierMedicalPatient2 = (DossierMedical)this.dossiersMedicaux.save(new DossierMedical(null, "AB +", "AA", null, null, patient2, null, null, null, null, null));
        Consultation consultation1 = (Consultation)this.consultations.save(new Consultation(null, "Paludisme", "Vomissement, maux de t\u00eate", "Owendo, Cite Octra", 10000.0, 10000.0, EtatOperation.TERMINEE, yesterdayDate, yesterdayDate, null, null, null, gynecologie, dossierMedicalPatient1, medecin2, null));
        this.consultations.save(new Consultation(null, "", "", "Owendo, Cite Octra", 10000.0, 7000.0, EtatOperation.EN_COURS, null, null, null, null, null, gynecologie, dossierMedicalPatient1, medecin2, null));
        this.consultations.save(new Consultation(null, "", "", "Owendo, Cite Octra", 10000.0, 5000.0, EtatOperation.EN_ATTENTE, null, null, null, null, null, gynecologie, dossierMedicalPatient2, medecin2, null));
        this.symptomes.save(new Symptome(null, "Purit vaginal", null, null, consultation1));
        this.symptomes.save(new Symptome(null, "Douleurs mammaires", null, null, consultation1));
        this.symptomes.save(new Symptome(null, "Pertes vaginal", null, null, consultation1));
        Examen examen1 = (Examen)this.examens.save(new Examen(null, "Radiographie pulmonaire", "Aucune anomalie", true, null, null, null, null, null));
        Examen examen2 = (Examen)this.examens.save(new Examen(null, "\u00c9chographie pelvienne", "Aucune anomalie", true, null, null, null, null, null));
        Examen examen3 = (Examen)this.examens.save(new Examen(null, "\u00c9chographie obst\u00e9tricale", "", false, null, null, null, null, null));
        Examen examen4 = (Examen)this.examens.save(new Examen(null, "IRM cardiaque", "Aucune anomalie", false, null, null, null, null, null));
        Examen examen5 = (Examen)this.examens.save(new Examen(null, "Coloscopie", "Aucune anomalie", true, null, null, null, null, null));
        Examen examen6 = (Examen)this.examens.save(new Examen(null, "Test de d\u00e9pistage du cancer", "N\u00e9gatif", true, null, null, null, null, null));
        Examen examen7 = (Examen)this.examens.save(new Examen(null, "Test de d\u00e9pistage du VIH", "N\u00e9gatif", true, null, null, null, null, null));
        BonExamen bonExamen1 = (BonExamen)this.bonExamens.save(new BonExamen(null, "3", "D\u00e9mangeaison", null, null, null, consultation1, null, gynecologie, dossierMedicalPatient1));
        Examen examen8 = (Examen)this.examens.save(new Examen(null, "Abdominal", "", true, null, null, null, bonExamen1, null));
        Examen examen9 = (Examen)this.examens.save(new Examen(null, "P\u00e9rin\u00e9al", "", true, null, null, null, bonExamen1, null));
        Examen examen10 = (Examen)this.examens.save(new Examen(null, "Pelvien", "", true, null, null, null, bonExamen1, null));
        TypeSoin typeSoin1 = (TypeSoin)this.typesSoins.save(new TypeSoin(null, "Vaccination", 2000.0, null, null, null));
        TypeSoin typeSoin2 = (TypeSoin)this.typesSoins.save(new TypeSoin(null, "Pansement plaie", 1000.0, null, null, null));
        this.typesSoins.save(new TypeSoin(null, "Pr\u00e9l\u00e8vement sanguin", 1500.0, null, null, null));
        this.typesSoins.save(new TypeSoin(null, "Test de grossesse", 2000.0, null, null, null));
        this.typesSoins.save(new TypeSoin(null, "Test de d\u00e9pistage", 1000.0, null, null, null));
        this.typesSoins.save(new TypeSoin(null, "R\u00e9\u00e9ducation physique", 10000.0, null, null, null));
        this.typesSoins.save(new TypeSoin(null, "Extraction de dents", 10000.0, null, null, null));
        this.typesSoins.save(new TypeSoin(null, "Echographie", 5000.0, null, null, null));
        this.typesSoins.save(new TypeSoin(null, "Obturation des caries", 15000.0, null, null, null));
        this.typesSoins.save(new TypeSoin(null, "S\u00e9ances de physioth\u00e9rapie", 15000.0, null, null, null));
        Facture facture1 = (Facture)this.factures.save(new Facture(null, UUID.randomUUID().toString(), null, false, 0, 0.0, 13000.0, 0.0, EtatFacture.PAYEE, null, null, consultation1, null, bonExamen1, null, null, null, patient1));
        Soin soin1 = (Soin)this.soins.save(new Soin(null, patient1.getNom() + " " + patient1.getPrenom(), "Aucune anomalie d\u00e9tect\u00e9e", typeSoin1.getPrix(), null, null, facture1, typeSoin1, gynecologie, dossierMedicalPatient1, infirmier1));
        Soin soin2 = (Soin)this.soins.save(new Soin(null, patient1.getNom() + " " + patient1.getPrenom(), "Aucune anomalie d\u00e9tect\u00e9e", typeSoin2.getPrix(), null, null, facture1, typeSoin2, gynecologie, dossierMedicalPatient1, infirmier1));
        this.rdv.save(new Rdv(null, "Chris Walker", "074990088", "M", new GregorianCalendar(2023, 7, 9).getTime(), "14h30", EtatOperation.EN_ATTENTE, null, null, medecin2, gynecologie));
        this.rdv.save(new Rdv(null, "Dorcas Oka", "066008800", "F", new GregorianCalendar(2023, 7, 10).getTime(), "11h30", EtatOperation.EN_ATTENTE, null, null, medecin2, gynecologie));
        this.chambres.save(new Chambre(null, "A", "01", "Standard", 2, 25000.0, null));
        this.chambres.save(new Chambre(null, "B", "01", "Individuelle", 1, 35000.0, null));
        this.chambres.save(new Chambre(null, "C", "01", "V.I.P", 1, 45000.0, null));
    }

    public void run(String ... strings) throws Exception {
    }
}

