/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Acte;
import org.hopeclinic.gestiondespatients.service.ActeService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/actes"})
public class ActeController {
    private final ActeService acteService;

    public ActeController(ActeService acteService) {
        this.acteService = acteService;
    }

    @GetMapping
    public List<Acte> getAllActes() {
        return this.acteService.getAllActes();
    }

    @GetMapping(value={"filter"})
    public List<Acte> getActesByFilters(@RequestParam Map<String, Object> filters) {
        return this.acteService.getActesByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.acteService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Acte> getActeById(@PathVariable Long id) {
        Acte acte = this.acteService.getActeById(id);
        if (acte != null) {
            return ResponseEntity.ok((Object)acte);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{serviceId}/service"})
    public List<Acte> getAllActesByServide(@PathVariable Long serviceId) {
        return this.acteService.getActesByService(serviceId);
    }

    @GetMapping(value={"/{periode}/{serviceId}/{personnelId}/service"})
    public List<Acte> getByFilter(@RequestParam(value="periode") String periode, @RequestParam(value="serviceId", required=false) Long serviceId, @RequestParam(value="personnelId", required=false) Long personnelId) {
        return this.acteService.getActesByPeriodeAndServiceAndPersonnel(serviceId, personnelId, periode);
    }

    @PostMapping
    public ResponseEntity<Acte> createActe(@RequestBody Acte acte) {
        Acte createdActe = this.acteService.createActe(acte);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdActe);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Acte> updateActe(@PathVariable Long id, @RequestBody Acte acte) {
        Acte updatedActe = this.acteService.updateActe(id, acte);
        if (updatedActe != null) {
            return ResponseEntity.ok((Object)updatedActe);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteActe(@PathVariable Long id) {
        boolean deleted = this.acteService.deleteActe(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

