/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import org.hopeclinic.gestiondespatients.model.Antecedent;
import org.hopeclinic.gestiondespatients.service.AntecedentService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/antecedents"})
public class AntecedentController {
    private final AntecedentService antecedentService;

    public AntecedentController(AntecedentService antecedentService) {
        this.antecedentService = antecedentService;
    }

    @GetMapping
    public List<Antecedent> getAllAntecedents() {
        return this.antecedentService.getAllAntecedents();
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.antecedentService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Antecedent> getAntecedentById(@PathVariable Long id) {
        Antecedent antecedent = this.antecedentService.getAntecedentById(id);
        if (antecedent != null) {
            return ResponseEntity.ok((Object)antecedent);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Antecedent> createAntecedent(@RequestBody Antecedent antecedent) {
        Antecedent createdAntecedent = this.antecedentService.createAntecedent(antecedent);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdAntecedent);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Antecedent> updateAntecedent(@PathVariable Long id, @RequestBody Antecedent antecedent) {
        Antecedent updatedAntecedent = this.antecedentService.updateAntecedent(id, antecedent);
        if (updatedAntecedent != null) {
            return ResponseEntity.ok((Object)updatedAntecedent);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteAntecedent(@PathVariable Long id) {
        boolean deleted = this.antecedentService.deleteAntecedent(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

