/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import org.hopeclinic.gestiondespatients.model.Assurance;
import org.hopeclinic.gestiondespatients.service.AssuranceService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assurances"})
public class AssuranceController {
    private final AssuranceService assuranceService;

    public AssuranceController(AssuranceService assuranceService) {
        this.assuranceService = assuranceService;
    }

    @GetMapping
    public List<Assurance> getAllAssurances() {
        return this.assuranceService.getAllAssurances();
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.assuranceService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Assurance> getAssuranceById(@PathVariable Long id) {
        Assurance assurance = this.assuranceService.getAssuranceById(id);
        if (assurance != null) {
            return ResponseEntity.ok((Object)assurance);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Assurance> createAssurance(@RequestBody Assurance assurance) {
        Assurance createdAssurance = this.assuranceService.createAssurance(assurance);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdAssurance);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Assurance> updateAssurance(@PathVariable Long id, @RequestBody Assurance assurance) {
        Assurance updatedAssurance = this.assuranceService.updateAssurance(id, assurance);
        if (updatedAssurance != null) {
            return ResponseEntity.ok((Object)updatedAssurance);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteAssurance(@PathVariable Long id) {
        boolean deleted = this.assuranceService.deleteAssurance(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

