/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.HashMap;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.service.CustomTokenService;
import org.hopeclinic.gestiondespatients.utils.CustomUserDetails;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/auth"})
public class AuthController {
    private final CustomTokenService tokenService;
    private static final Logger LOG = LoggerFactory.getLogger(AuthController.class);

    public AuthController(CustomTokenService tokenService) {
        this.tokenService = tokenService;
    }

    @PostMapping(value={"/login"})
    public ResponseEntity<Map<String, Object>> login(Authentication authentication) {
        if (authentication != null && authentication.getPrincipal() instanceof CustomUserDetails) {
            CustomUserDetails userDetails = (CustomUserDetails)authentication.getPrincipal();
            PersonnelMedical personnelMedical = userDetails.getPersonnelMedical();
            String token = this.tokenService.generateToken(authentication);
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("user", personnelMedical);
            res.put("token", token);
            return new ResponseEntity(res, HttpStatus.OK);
        }
        return new ResponseEntity(null, HttpStatus.UNAUTHORIZED);
    }
}

