/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.service.BonExamenService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bons_examens"})
public class BonExamenController {
    private final BonExamenService bonExamenService;

    public BonExamenController(BonExamenService bonExamenService) {
        this.bonExamenService = bonExamenService;
    }

    @GetMapping
    public List<BonExamen> getAllBonExamens() {
        return this.bonExamenService.getAllBonExamens();
    }

    @GetMapping(value={"filter"})
    public List<BonExamen> getBonExamensByFilters(@RequestParam Map<String, Object> filters) {
        return this.bonExamenService.getBonExamensByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.bonExamenService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<BonExamen> getBonExamenById(@PathVariable Long id) {
        BonExamen bonExamen = this.bonExamenService.getBonExamenById(id);
        if (bonExamen != null) {
            return ResponseEntity.ok((Object)bonExamen);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<BonExamen> createBonExamen(@RequestBody BonExamen bonExamen) {
        BonExamen createdBonExamen = this.bonExamenService.createBonExamen(bonExamen);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdBonExamen);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<BonExamen> updateBonExamen(@PathVariable Long id, @RequestBody BonExamen bonExamen) {
        BonExamen updatedBonExamen = this.bonExamenService.updateBonExamen(id, bonExamen);
        if (updatedBonExamen != null) {
            return ResponseEntity.ok((Object)updatedBonExamen);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteBonExamen(@PathVariable Long id) {
        boolean deleted = this.bonExamenService.deleteBonExamen(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

