/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import org.hopeclinic.gestiondespatients.model.Chambre;
import org.hopeclinic.gestiondespatients.service.ChambreService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/chambres"})
public class ChambreController {
    private final ChambreService chambreService;

    public ChambreController(ChambreService chambreService) {
        this.chambreService = chambreService;
    }

    @GetMapping
    public List<Chambre> getAllChambres() {
        return this.chambreService.getAllChambres();
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.chambreService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Chambre> getChambreById(@PathVariable Long id) {
        Chambre chambre = this.chambreService.getChambreById(id);
        if (chambre != null) {
            return ResponseEntity.ok((Object)chambre);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Chambre> createChambre(@RequestBody Chambre chambre) {
        Chambre createdChambre = this.chambreService.createChambre(chambre);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdChambre);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Chambre> updateChambre(@PathVariable Long id, @RequestBody Chambre chambre) {
        Chambre updatedChambre = this.chambreService.updateChambre(id, chambre);
        if (updatedChambre != null) {
            return ResponseEntity.ok((Object)updatedChambre);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteChambre(@PathVariable Long id) {
        boolean deleted = this.chambreService.deleteChambre(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

