/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.service.ConsultationService;
import org.hopeclinic.gestiondespatients.type.EtatOperation;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/consultations"})
public class ConsultationController {
    private final ConsultationService consultationService;

    public ConsultationController(ConsultationService consultationService) {
        this.consultationService = consultationService;
    }

    @GetMapping
    public List<Consultation> getAllConsultations() {
        return this.consultationService.getAllConsultations();
    }

    @GetMapping(value={"filter"})
    public List<Consultation> getConsultationsByFilters(@RequestParam Map<String, Object> filters) {
        return this.consultationService.getConsultationsByFilters(filters);
    }

    @GetMapping(value={"/count/{etat}"})
    public long countConsutationsByEtat(@PathVariable EtatOperation etat) {
        return this.consultationService.countConsultationsByEtat(etat);
    }

    @GetMapping(value={"/today/count"})
    public ResponseEntity<Long> getTodayConsultationCount() {
        long count = this.consultationService.getTodayConsultationCount();
        return ResponseEntity.ok((Object)count);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.consultationService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Consultation> getConsultationById(@PathVariable Long id) {
        Consultation consultation = this.consultationService.getConsultationById(id);
        if (consultation != null) {
            return ResponseEntity.ok((Object)consultation);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/dossier_medical"})
    public ResponseEntity<DossierMedical> getDossierMedicalByConsultationId(@PathVariable Long id) {
        Consultation consultation = this.consultationService.getConsultationById(id);
        if (consultation != null) {
            return ResponseEntity.ok((Object)consultation.getDossierMedical());
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/patient"})
    public ResponseEntity<Patient> getPatientByConsultationId(@PathVariable Long id) {
        Consultation consultation = this.consultationService.getConsultationById(id);
        if (consultation != null) {
            return ResponseEntity.ok((Object)consultation.getDossierMedical().getPatient());
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Consultation> createConsultation(@RequestBody Consultation consultation) {
        Consultation createdConsultation = this.consultationService.createConsultation(consultation);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdConsultation);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Consultation> updateConsultation(@PathVariable Long id, @RequestBody Consultation consultation) {
        Consultation updatedConsultation = this.consultationService.updateConsultation(id, consultation);
        if (updatedConsultation != null) {
            return ResponseEntity.ok((Object)updatedConsultation);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteConsultation(@PathVariable Long id) {
        boolean deleted = this.consultationService.deleteConsultation(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

