/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Antecedent;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Ordonnance;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.model.Soin;
import org.hopeclinic.gestiondespatients.service.DossierMedicalService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dossiers_medicaux"})
public class DossierMedicalController {
    private final DossierMedicalService dossierMedicalService;

    public DossierMedicalController(DossierMedicalService dossierMedicalService) {
        this.dossierMedicalService = dossierMedicalService;
    }

    @GetMapping
    public List<DossierMedical> getAllDossierMedicals() {
        return this.dossierMedicalService.getAllDossierMedicals();
    }

    @GetMapping(value={"filter"})
    public List<DossierMedical> getDossierMedicalsByFilters(@RequestParam Map<String, Object> filters) {
        return this.dossierMedicalService.getDossierMedicalByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.dossierMedicalService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<DossierMedical> getDossierMedicalById(@PathVariable Long id) {
        DossierMedical dossierMedical = this.dossierMedicalService.getDossierMedicalById(id);
        if (dossierMedical != null) {
            return ResponseEntity.ok((Object)dossierMedical);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/patient"})
    public ResponseEntity<Patient> getPatientByDossierMedicalId(@PathVariable Long id) {
        DossierMedical dossierMedical = this.dossierMedicalService.getDossierMedicalById(id);
        if (dossierMedical != null) {
            return ResponseEntity.ok((Object)dossierMedical.getPatient());
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/consultations"})
    public List<Consultation> getConsultationsByDossierMedicalId(@PathVariable Long id) {
        return this.dossierMedicalService.getConsultationsByDossierMedical(id);
    }

    @GetMapping(value={"/{id}/ordonnances"})
    public List<Ordonnance> getOrdonnancesByDossierMedicalId(@PathVariable Long id) {
        return this.dossierMedicalService.getOrdonnancesByDossierMedical(id);
    }

    @GetMapping(value={"/{id}/bon_examens"})
    public List<BonExamen> getBonExamenByDossierMedicalId(@PathVariable Long id) {
        return this.dossierMedicalService.getBonExamensByDossierMedical(id);
    }

    @GetMapping(value={"/{id}/soins"})
    public List<Soin> getSoinsByDossierMedicalId(@PathVariable Long id) {
        return this.dossierMedicalService.getSoinsByDossierMedical(id);
    }

    @GetMapping(value={"/{id}/antecedents"})
    public List<Antecedent> getAntecedentsByDossierMedicalId(@PathVariable Long id) {
        return this.dossierMedicalService.getAntecedentsByDossierMedical(id);
    }

    @PostMapping
    public ResponseEntity<DossierMedical> createDossierMedical(@RequestBody DossierMedical dossierMedical) {
        DossierMedical createdDossierMedical = this.dossierMedicalService.createDossierMedical(dossierMedical);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdDossierMedical);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<DossierMedical> updateDossierMedical(@PathVariable Long id, @RequestBody DossierMedical dossierMedical) {
        DossierMedical updatedDossierMedical = this.dossierMedicalService.updateDossierMedical(id, dossierMedical);
        if (updatedDossierMedical != null) {
            return ResponseEntity.ok((Object)updatedDossierMedical);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteDossierMedical(@PathVariable Long id) {
        boolean deleted = this.dossierMedicalService.deleteDossierMedical(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

