/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hopeclinic.gestiondespatients.model.Examen;
import org.hopeclinic.gestiondespatients.service.ExamenService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/examens"})
public class ExamenController {
    private final ExamenService examenService;

    public ExamenController(ExamenService examenService) {
        this.examenService = examenService;
    }

    @GetMapping
    public List<Examen> getAllExamens() {
        return this.examenService.getAllExamens();
    }

    @GetMapping(value={"filter"})
    public List<Examen> getExamensByFilters(@RequestParam Map<String, Object> filters) {
        return this.examenService.getExamensByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.examenService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Examen> getExamenById(@PathVariable Long id) {
        Examen examen = this.examenService.getExamenById(id);
        if (examen != null) {
            return ResponseEntity.ok((Object)examen);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/file"})
    public List<String> getFileLines() throws IOException {
        ClassPathResource resource = new ClassPathResource("static/examens.txt");
        String fileContent = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        List<String> lines = fileContent.lines().collect(Collectors.toList());
        return lines;
    }

    @PostMapping
    public ResponseEntity<Examen> createExamen(@RequestBody Examen examen) {
        Examen createdExamen = this.examenService.createExamen(examen);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdExamen);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Examen> updateExamen(@PathVariable Long id, @RequestBody Examen examen) {
        Examen updatedExamen = this.examenService.updateExamen(id, examen);
        if (updatedExamen != null) {
            return ResponseEntity.ok((Object)updatedExamen);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteExamen(@PathVariable Long id) {
        boolean deleted = this.examenService.deleteExamen(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

