/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.service.FactureService;
import org.hopeclinic.gestiondespatients.type.EtatFacture;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/factures"})
public class FactureController {
    private final FactureService factureService;

    public FactureController(FactureService factureService) {
        this.factureService = factureService;
    }

    @GetMapping
    public List<Facture> getAllFactures() {
        return this.factureService.getAllFactures();
    }

    @GetMapping(value={"filter"})
    public List<Facture> getFacturesByFilters(@RequestParam Map<String, Object> filters) {
        return this.factureService.getFacturesByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.factureService.count();
    }

    @GetMapping(value={"/count/{etat}"})
    public long countFacturesByEtat(@PathVariable EtatFacture etat) {
        return this.factureService.countFacturesByEtat(etat);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Facture> getFactureById(@PathVariable Long id) {
        Facture facture = this.factureService.getFactureById(id);
        if (facture != null) {
            return ResponseEntity.ok((Object)facture);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/consultation"})
    public ResponseEntity<Consultation> getConsultationByFactureId(@PathVariable Long id) {
        Consultation consultation = this.factureService.getConsultationByFactureId(id);
        return ResponseEntity.ok((Object)consultation);
    }

    @GetMapping(value={"/{id}/bon_examen"})
    public ResponseEntity<BonExamen> getBonExamenByFactureId(@PathVariable Long id) {
        BonExamen bonExamen = this.factureService.getBonExamenByFactureId(id);
        return ResponseEntity.ok((Object)bonExamen);
    }

    @PostMapping
    public ResponseEntity<Facture> createFacture(@RequestBody Facture facture) {
        Facture createdFacture = this.factureService.createFacture(facture);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdFacture);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Facture> updateFacture(@PathVariable Long id, @RequestBody Facture facture) {
        Facture updatedFacture = this.factureService.updateFacture(id, facture);
        if (updatedFacture != null) {
            return ResponseEntity.ok((Object)updatedFacture);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteFacture(@PathVariable Long id) {
        boolean deleted = this.factureService.deleteFacture(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

