/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Hospitalisation;
import org.hopeclinic.gestiondespatients.service.HospitalisationService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hospitalisations"})
public class HospitalisationController {
    private final HospitalisationService hospitalisationService;

    public HospitalisationController(HospitalisationService hospitalisationService) {
        this.hospitalisationService = hospitalisationService;
    }

    @GetMapping
    public List<Hospitalisation> getAllHospitalisations() {
        return this.hospitalisationService.getAllHospitalisations();
    }

    @GetMapping(value={"filter"})
    public List<Hospitalisation> getHospitalisationsByFilters(@RequestParam Map<String, Object> filters) {
        return this.hospitalisationService.getHospitalisationsByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.hospitalisationService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Hospitalisation> getHospitalisationById(@PathVariable Long id) {
        Hospitalisation hospitalisation = this.hospitalisationService.getHospitalisationById(id);
        if (hospitalisation != null) {
            return ResponseEntity.ok((Object)hospitalisation);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Hospitalisation> createHospitalisation(@RequestBody Hospitalisation hospitalisation) {
        Hospitalisation createdHospitalisation = this.hospitalisationService.createHospitalisation(hospitalisation);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdHospitalisation);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Hospitalisation> updateHospitalisation(@PathVariable Long id, @RequestBody Hospitalisation hospitalisation) {
        Hospitalisation updatedHospitalisation = this.hospitalisationService.updateHospitalisation(id, hospitalisation);
        if (updatedHospitalisation != null) {
            return ResponseEntity.ok((Object)updatedHospitalisation);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteHospitalisation(@PathVariable Long id) {
        boolean deleted = this.hospitalisationService.deleteHospitalisation(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

