/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Ordonnance;
import org.hopeclinic.gestiondespatients.service.OrdonnanceService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ordonnances"})
public class OrdonnanceController {
    private final OrdonnanceService ordonnanceService;

    public OrdonnanceController(OrdonnanceService ordonnanceService) {
        this.ordonnanceService = ordonnanceService;
    }

    @GetMapping
    public List<Ordonnance> getAllOrdonnances() {
        return this.ordonnanceService.getAllOrdonnances();
    }

    @GetMapping(value={"filter"})
    public List<Ordonnance> getOrdonnancesByFilters(@RequestParam Map<String, Object> filters) {
        return this.ordonnanceService.getOrdonnancesByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.ordonnanceService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Ordonnance> getOrdonnanceById(@PathVariable Long id) {
        Ordonnance ordonnance = this.ordonnanceService.getOrdonnanceById(id);
        if (ordonnance != null) {
            return ResponseEntity.ok((Object)ordonnance);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Ordonnance> createOrdonnance(@RequestBody Ordonnance ordonnance) {
        Ordonnance createdOrdonnance = this.ordonnanceService.createOrdonnance(ordonnance);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdOrdonnance);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Ordonnance> updateOrdonnance(@PathVariable Long id, @RequestBody Ordonnance ordonnance) {
        Ordonnance updatedOrdonnance = this.ordonnanceService.updateOrdonnance(id, ordonnance);
        if (updatedOrdonnance != null) {
            return ResponseEntity.ok((Object)updatedOrdonnance);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteOrdonnance(@PathVariable Long id) {
        boolean deleted = this.ordonnanceService.deleteOrdonnance(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

