/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.service.PatientService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/patients"})
public class PatientController {
    private final PatientService patientService;

    public PatientController(PatientService patientService) {
        this.patientService = patientService;
    }

    @GetMapping
    public List<Patient> getAllPatients() {
        return this.patientService.getAllPatients();
    }

    @GetMapping(value={"filter"})
    public List<Patient> getPatientsByFilters(@RequestParam Map<String, Object> filters) {
        return this.patientService.getPatientsByFilters(filters);
    }

    @GetMapping(value={"count/sex"})
    public Map<String, Long> countBySex() {
        return this.patientService.getPatientStatsBySexe();
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.patientService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Patient> getPatientById(@PathVariable Long id) {
        Patient patient = this.patientService.getPatientById(id);
        if (patient != null) {
            return ResponseEntity.ok((Object)patient);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/dossier_medical"})
    public DossierMedical getDossierMedicalPatientId(@PathVariable Long id) {
        return this.patientService.getDossierMedicalByPatient(id);
    }

    @PostMapping
    public ResponseEntity<Patient> createPatient(@RequestBody Patient patient) {
        Patient createdPatient = this.patientService.createPatient(patient);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdPatient);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Patient> updatePatient(@PathVariable Long id, @RequestBody Patient patient) {
        Patient updatedPatient = this.patientService.updatePatient(id, patient);
        if (updatedPatient != null) {
            return ResponseEntity.ok((Object)updatedPatient);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletePatient(@PathVariable Long id) {
        boolean deleted = this.patientService.deletePatient(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

