/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Hospitalisation;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Rdv;
import org.hopeclinic.gestiondespatients.service.PersonnelMedicalService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/personnels"})
public class PersonnelMedicalController {
    private final PersonnelMedicalService personnelMedicalService;

    public PersonnelMedicalController(PersonnelMedicalService personnelMedicalService) {
        this.personnelMedicalService = personnelMedicalService;
    }

    @GetMapping
    public ResponseEntity<List<PersonnelMedical>> getAllPersonnelsMedicaux() {
        List<PersonnelMedical> personnelMedicals = this.personnelMedicalService.getAllPersonnelsMedicaux();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(personnelMedicals);
    }

    @GetMapping(value={"filter"})
    public List<PersonnelMedical> getPersonnelMedicalByFilters(@RequestParam Map<String, Object> filters) {
        return this.personnelMedicalService.getPersonnelMedicalByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.personnelMedicalService.count();
    }

    @GetMapping(value={"/count/{roleId}"})
    public Long count(@PathVariable Long roleId) {
        return this.personnelMedicalService.countByPersonnelRole(roleId);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PersonnelMedical> getPersonnelMedicalById(@PathVariable Long id) {
        PersonnelMedical personnelMedical = this.personnelMedicalService.getPersonnelMedicalById(id);
        if (personnelMedical != null) {
            return ResponseEntity.ok((Object)personnelMedical);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{personnelMedicalId}/consultations"})
    public List<Consultation> getConsultationByPersonnelMedical(@PathVariable Long personnelMedicalId) {
        return this.personnelMedicalService.getConsultationsByPersonnelMedical(personnelMedicalId);
    }

    @GetMapping(value={"/{personnelMedicalId}/hospitalisations"})
    public List<Hospitalisation> getHospitalisationByPersonnelMedical(@PathVariable Long personnelMedicalId) {
        return this.personnelMedicalService.getHospitalisationsByPersonnelMedical(personnelMedicalId);
    }

    @GetMapping(value={"/{personnelMedicalId}/rdv"})
    public List<Rdv> getRdvByPersonnelMedical(@PathVariable Long personnelMedicalId) {
        return this.personnelMedicalService.getRdvByPersonnelMedical(personnelMedicalId);
    }

    @PostMapping
    public ResponseEntity<PersonnelMedical> createPersonnelMedical(@RequestBody(required=false) PersonnelMedical personnelMedical) {
        this.personnelMedicalService.validerPersonnelMedical(personnelMedical);
        PersonnelMedical createdPersonnelMedical = this.personnelMedicalService.createPersonnelMedical(personnelMedical);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdPersonnelMedical);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PersonnelMedical> updatePersonnelMedical(@PathVariable Long id, @RequestBody PersonnelMedical personnelMedical) {
        this.personnelMedicalService.validerPersonnelMedical(personnelMedical);
        PersonnelMedical updatedPersonnelMedical = this.personnelMedicalService.updatePersonnelMedical(id, personnelMedical);
        if (updatedPersonnelMedical != null) {
            return ResponseEntity.ok((Object)updatedPersonnelMedical);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletePersonnelMedical(@PathVariable Long id) {
        boolean deleted = this.personnelMedicalService.deletePersonnelMedical(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

