/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Prescription;
import org.hopeclinic.gestiondespatients.service.PrescriptionService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/prescriptions"})
public class PrescriptionController {
    private final PrescriptionService prescriptionService;

    public PrescriptionController(PrescriptionService prescriptionService) {
        this.prescriptionService = prescriptionService;
    }

    @GetMapping
    public List<Prescription> getAllPrescriptions() {
        return this.prescriptionService.getAllPrescriptions();
    }

    @GetMapping(value={"filter"})
    public List<Prescription> getPrescriptionsByFilters(@RequestParam Map<String, Object> filters) {
        return this.prescriptionService.getPrescriptionsByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.prescriptionService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Prescription> getPrescriptionById(@PathVariable Long id) {
        Prescription prescription = this.prescriptionService.getPrescriptionById(id);
        if (prescription != null) {
            return ResponseEntity.ok((Object)prescription);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Prescription> createPrescription(@RequestBody Prescription prescription) {
        Prescription createdPrescription = this.prescriptionService.createPrescription(prescription);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdPrescription);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Prescription> updatePrescription(@PathVariable Long id, @RequestBody Prescription prescription) {
        Prescription updatedPrescription = this.prescriptionService.updatePrescription(id, prescription);
        if (updatedPrescription != null) {
            return ResponseEntity.ok((Object)updatedPrescription);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletePrescription(@PathVariable Long id) {
        boolean deleted = this.prescriptionService.deletePrescription(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

