/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Rdv;
import org.hopeclinic.gestiondespatients.service.RdvService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rdv"})
public class RdvController {
    private final RdvService rdvService;

    public RdvController(RdvService rdvService) {
        this.rdvService = rdvService;
    }

    @GetMapping
    public List<Rdv> getAllRdv() {
        return this.rdvService.getAllRdv();
    }

    @GetMapping(value={"filter"})
    public List<Rdv> getRdvByFilters(@RequestParam Map<String, Object> filters) {
        return this.rdvService.getRdvByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.rdvService.count();
    }

    @GetMapping(value={"/today/count"})
    public ResponseEntity<Long> getTodayRdvCount() {
        long count = this.rdvService.getTodayRdvCount();
        return ResponseEntity.ok((Object)count);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Rdv> getRdvById(@PathVariable Long id) {
        Rdv rdv = this.rdvService.getRdvById(id);
        if (rdv != null) {
            return ResponseEntity.ok((Object)rdv);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/personnel"})
    public ResponseEntity<PersonnelMedical> getPersonnelMedicalByRdvId(@PathVariable Long id) {
        Rdv rdv = this.rdvService.getRdvById(id);
        if (rdv != null) {
            return ResponseEntity.ok((Object)rdv.getPersonnelMedical());
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Rdv> createRdv(@RequestBody Rdv rdv) {
        Rdv createdRdv = this.rdvService.createRdv(rdv);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdRdv);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Rdv> updateRdv(@PathVariable Long id, @RequestBody Rdv rdv) {
        Rdv updatedRdv = this.rdvService.updateRdv(id, rdv);
        if (updatedRdv != null) {
            return ResponseEntity.ok((Object)updatedRdv);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteRdv(@PathVariable Long id) {
        boolean deleted = this.rdvService.deleteRdv(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

