/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.model.Recu;
import org.hopeclinic.gestiondespatients.service.RecuService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/recus"})
public class RecuController {
    private final RecuService recuService;

    public RecuController(RecuService recuService) {
        this.recuService = recuService;
    }

    @GetMapping
    public List<Recu> getAllRecus() {
        return this.recuService.getAllRecus();
    }

    @GetMapping(value={"filter"})
    public List<Recu> getRecusByFilters(@RequestParam Map<String, Object> filters) {
        return this.recuService.getRecusByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.recuService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Recu> getRecuById(@PathVariable Long id) {
        Recu recu = this.recuService.getRecuById(id);
        if (recu != null) {
            return ResponseEntity.ok((Object)recu);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/{id}/patient"})
    public ResponseEntity<Patient> getPatientByRecuId(@PathVariable Long id) {
        Recu recu = this.recuService.getRecuById(id);
        if (recu != null) {
            return ResponseEntity.ok((Object)recu.getPatient());
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Recu> createRecu(@RequestBody Recu recu) {
        Recu createdRecu = this.recuService.createRecu(recu);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdRecu);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Recu> updateRecu(@PathVariable Long id, @RequestBody Recu recu) {
        Recu updatedRecu = this.recuService.updateRecu(id, recu);
        if (updatedRecu != null) {
            return ResponseEntity.ok((Object)updatedRecu);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteRecu(@PathVariable Long id) {
        boolean deleted = this.recuService.deleteRecu(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

