/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import java.util.Map;
import org.hopeclinic.gestiondespatients.model.Role;
import org.hopeclinic.gestiondespatients.service.RoleService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/roles"})
public class RoleController {
    private final RoleService roleService;

    public RoleController(RoleService roleService) {
        this.roleService = roleService;
    }

    @GetMapping
    public List<Role> getAllRoles() {
        return this.roleService.getAllRoles();
    }

    @GetMapping(value={"filter"})
    public List<Role> getRolesByFilters(@RequestParam Map<String, Object> filters) {
        return this.roleService.getRolesByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.roleService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Role> getRoleById(@PathVariable Long id) {
        Role role = this.roleService.getRoleById(id);
        if (role != null) {
            return ResponseEntity.ok((Object)role);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<Role> createRole(@RequestBody Role role) {
        Role createdRole = this.roleService.createRole(role);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdRole);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Role> updateRole(@PathVariable Long id, @RequestBody Role role) {
        Role updatedRole = this.roleService.updateRole(id, role);
        if (updatedRole != null) {
            return ResponseEntity.ok((Object)updatedRole);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteRole(@PathVariable Long id) {
        boolean deleted = this.roleService.deleteRole(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

