/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hopeclinic.gestiondespatients.model.Service;
import org.hopeclinic.gestiondespatients.service.ServiceService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/services"})
public class ServiceController {
    private final ServiceService serviceService;

    public ServiceController(ServiceService serviceService) {
        this.serviceService = serviceService;
    }

    @GetMapping
    public List<Service> getAllServices() {
        return this.serviceService.getAllServices();
    }

    @GetMapping(value={"filter"})
    public List<Service> getServicesByFilters(@RequestParam Map<String, Object> filters) {
        return this.serviceService.getServicesByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.serviceService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Service> getServiceById(@PathVariable Long id) {
        Service service = this.serviceService.getServiceById(id);
        if (service != null) {
            return ResponseEntity.ok((Object)service);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/file"})
    public List<String> getFileLines() throws IOException {
        ClassPathResource resource = new ClassPathResource("static/specialites.txt");
        String fileContent = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        List<String> lines = fileContent.lines().collect(Collectors.toList());
        return lines;
    }

    @PostMapping
    public ResponseEntity<Service> createService(@RequestBody Service service) {
        Service createdService = this.serviceService.createService(service);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdService);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Service> updateService(@PathVariable Long id, @RequestBody Service service) {
        Service updatedService = this.serviceService.updateService(id, service);
        if (updatedService != null) {
            return ResponseEntity.ok((Object)updatedService);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteService(@PathVariable Long id) {
        boolean deleted = this.serviceService.deleteService(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

