/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hopeclinic.gestiondespatients.model.Soin;
import org.hopeclinic.gestiondespatients.service.SoinService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/soins"})
public class SoinController {
    private final SoinService soinService;

    public SoinController(SoinService soinService) {
        this.soinService = soinService;
    }

    @GetMapping
    public List<Soin> getAllSoins() {
        return this.soinService.getAllSoins();
    }

    @GetMapping(value={"filter"})
    public List<Soin> getSoinsByFilters(@RequestParam Map<String, Object> filters) {
        return this.soinService.getSoinsByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.soinService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Soin> getSoinById(@PathVariable Long id) {
        Soin soin = this.soinService.getSoinById(id);
        if (soin != null) {
            return ResponseEntity.ok((Object)soin);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<List<Soin>> createSoins(@RequestBody List<Soin> soins) {
        List<Soin> createdSoins = this.soinService.createSoins(soins);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body(createdSoins);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Soin> updateSoin(@PathVariable Long id, @RequestBody Soin soin) {
        Soin updatedSoin = this.soinService.updateSoin(id, soin);
        if (updatedSoin != null) {
            return ResponseEntity.ok((Object)updatedSoin);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/file"})
    public List<String> getFileLines() throws IOException {
        ClassPathResource resource = new ClassPathResource("static/soins.txt");
        String fileContent = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        List<String> lines = fileContent.lines().collect(Collectors.toList());
        return lines;
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteSoin(@PathVariable Long id) {
        boolean deleted = this.soinService.deleteSoin(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

