/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hopeclinic.gestiondespatients.model.Symptome;
import org.hopeclinic.gestiondespatients.service.SymptomeService;
import org.springframework.core.io.ClassPathResource;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/symptomes"})
public class SymptomeController {
    private final SymptomeService symptomeService;

    public SymptomeController(SymptomeService symptomeService) {
        this.symptomeService = symptomeService;
    }

    @GetMapping
    public List<Symptome> getAllSymptomes() {
        return this.symptomeService.getAllSymptomes();
    }

    @GetMapping(value={"filter"})
    public List<Symptome> getSymptomesByFilters(@RequestParam Map<String, Object> filters) {
        return this.symptomeService.getSymptomesByFilters(filters);
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.symptomeService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Symptome> getSymptomeById(@PathVariable Long id) {
        Symptome symptome = this.symptomeService.getSymptomeById(id);
        if (symptome != null) {
            return ResponseEntity.ok((Object)symptome);
        }
        return ResponseEntity.notFound().build();
    }

    @GetMapping(value={"/file"})
    public List<String> getFileLines() throws IOException {
        ClassPathResource resource = new ClassPathResource("static/symptomes.txt");
        String fileContent = StreamUtils.copyToString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        List<String> lines = fileContent.lines().collect(Collectors.toList());
        return lines;
    }

    @PostMapping
    public ResponseEntity<Symptome> createSymptome(@RequestBody Symptome symptome) {
        Symptome createdSymptome = this.symptomeService.createSymptome(symptome);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdSymptome);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Symptome> updateSymptome(@PathVariable Long id, @RequestBody Symptome symptome) {
        Symptome updatedSymptome = this.symptomeService.updateSymptome(id, symptome);
        if (updatedSymptome != null) {
            return ResponseEntity.ok((Object)updatedSymptome);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteSymptome(@PathVariable Long id) {
        boolean deleted = this.symptomeService.deleteSymptome(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

