/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import org.hopeclinic.gestiondespatients.model.TypeExamen;
import org.hopeclinic.gestiondespatients.service.TypeExamenService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/types_examens"})
public class TypeExamenController {
    private final TypeExamenService typeExamenService;

    public TypeExamenController(TypeExamenService typeExamenService) {
        this.typeExamenService = typeExamenService;
    }

    @GetMapping
    public List<TypeExamen> getAllTypeExamens() {
        return this.typeExamenService.getAllTypeExamens();
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.typeExamenService.count();
    }

    @GetMapping(value={"/{service}/service"})
    public List<TypeExamen> getByService(@PathVariable String service) {
        return this.typeExamenService.getByService(service);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TypeExamen> getTypeExamenById(@PathVariable Long id) {
        TypeExamen typeExamen = this.typeExamenService.getTypeExamenById(id);
        if (typeExamen != null) {
            return ResponseEntity.ok((Object)typeExamen);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<TypeExamen> createTypeExamen(@RequestBody TypeExamen typeExamen) {
        TypeExamen createdTypeExamen = this.typeExamenService.createTypeExamen(typeExamen);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdTypeExamen);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<TypeExamen> updateTypeExamen(@PathVariable Long id, @RequestBody TypeExamen typeExamen) {
        TypeExamen updatedTypeExamen = this.typeExamenService.updateTypeExamen(id, typeExamen);
        if (updatedTypeExamen != null) {
            return ResponseEntity.ok((Object)updatedTypeExamen);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteTypeExamen(@PathVariable Long id) {
        boolean deleted = this.typeExamenService.deleteTypeExamen(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

