/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.controller;

import java.util.List;
import org.hopeclinic.gestiondespatients.model.TypeSoin;
import org.hopeclinic.gestiondespatients.service.TypeSoinService;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/types_soins"})
public class TypeSoinController {
    private final TypeSoinService typeSoinService;

    public TypeSoinController(TypeSoinService typeSoinService) {
        this.typeSoinService = typeSoinService;
    }

    @GetMapping
    public List<TypeSoin> getAllTypeSoins() {
        return this.typeSoinService.getAllTypeSoins();
    }

    @GetMapping(value={"/count"})
    public Long count() {
        return this.typeSoinService.count();
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<TypeSoin> getTypeSoinById(@PathVariable Long id) {
        TypeSoin typeSoin = this.typeSoinService.getTypeSoinById(id);
        if (typeSoin != null) {
            return ResponseEntity.ok((Object)typeSoin);
        }
        return ResponseEntity.notFound().build();
    }

    @PostMapping
    public ResponseEntity<TypeSoin> createTypeSoin(@RequestBody TypeSoin typeSoin) {
        TypeSoin createdTypeSoin = this.typeSoinService.createTypeSoin(typeSoin);
        return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)createdTypeSoin);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<TypeSoin> updateTypeSoin(@PathVariable Long id, @RequestBody TypeSoin typeSoin) {
        TypeSoin updatedTypeSoin = this.typeSoinService.updateTypeSoin(id, typeSoin);
        if (updatedTypeSoin != null) {
            return ResponseEntity.ok((Object)updatedTypeSoin);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteTypeSoin(@PathVariable Long id) {
        boolean deleted = this.typeSoinService.deleteTypeSoin(id);
        if (deleted) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.notFound().build();
    }
}

