/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Hospitalisation;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Service;

@Entity
@Table(name="acte")
public class Acte {
    @Id
    @GeneratedValue
    private Long id;
    private String observation;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="personnel_medical_id")
    private PersonnelMedical personnelMedical;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="hospitalisation_id")
    private Hospitalisation hospitalisation;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="service_id")
    private Service service;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Acte(Long id, String observation, Date dateCreation, Date dateModification, PersonnelMedical personnelMedical, Hospitalisation hospitalisation, Service service) {
        this.id = id;
        this.observation = observation;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.personnelMedical = personnelMedical;
        this.hospitalisation = hospitalisation;
        this.service = service;
    }

    public Acte() {
    }

    public Long getId() {
        return this.id;
    }

    public String getObservation() {
        return this.observation;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public PersonnelMedical getPersonnelMedical() {
        return this.personnelMedical;
    }

    public Hospitalisation getHospitalisation() {
        return this.hospitalisation;
    }

    public Service getService() {
        return this.service;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setObservation(String observation) {
        this.observation = observation;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setPersonnelMedical(PersonnelMedical personnelMedical) {
        this.personnelMedical = personnelMedical;
    }

    @JsonIgnore
    public void setHospitalisation(Hospitalisation hospitalisation) {
        this.hospitalisation = hospitalisation;
    }

    @JsonIgnore
    public void setService(Service service) {
        this.service = service;
    }
}

