/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.type.AntecedentType;

@Entity(name="Antecedent")
@Table(name="antecedent")
public class Antecedent {
    @Id
    @GeneratedValue
    private Long id;
    @Column(name="nom")
    private String nom;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="dossier_medical_id")
    private DossierMedical dossierMedical;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    private AntecedentType type;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Antecedent(Long id, String nom, Date dateCreation, Date dateModification, DossierMedical dossierMedical, AntecedentType type) {
        this.id = id;
        this.nom = nom;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.dossierMedical = dossierMedical;
        this.type = type;
    }

    public Antecedent() {
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public DossierMedical getDossierMedical() {
        return this.dossierMedical;
    }

    public AntecedentType getType() {
        return this.type;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setDossierMedical(DossierMedical dossierMedical) {
        this.dossierMedical = dossierMedical;
    }

    public void setType(AntecedentType type) {
        this.type = type;
    }
}

