/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Patient;

@Entity
@Table(name="assurance")
public class Assurance {
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private String nom;
    @Column
    private String description;
    @Column
    private String image;
    @Column
    private Integer taux;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @OneToMany(mappedBy="assurance", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Facture> factures = new ArrayList<Facture>();
    @JsonIgnore
    @ManyToMany
    @JoinTable(name="assurance_patient", joinColumns={@JoinColumn(name="assurance_id")}, inverseJoinColumns={@JoinColumn(name="patient_id")})
    private List<Patient> patients;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Assurance(Long id, String nom, String description, String image, Integer taux, Date dateCreation, Date dateModification, List<Facture> factures, List<Patient> patients) {
        this.id = id;
        this.nom = nom;
        this.description = description;
        this.image = image;
        this.taux = taux;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.factures = factures;
        this.patients = patients;
    }

    public Assurance() {
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public String getDescription() {
        return this.description;
    }

    public String getImage() {
        return this.image;
    }

    public Integer getTaux() {
        return this.taux;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public List<Facture> getFactures() {
        return this.factures;
    }

    public List<Patient> getPatients() {
        return this.patients;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setTaux(Integer taux) {
        this.taux = taux;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setFactures(List<Facture> factures) {
        this.factures = factures;
    }

    @JsonIgnore
    public void setPatients(List<Patient> patients) {
        this.patients = patients;
    }
}

