/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Examen;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Service;

@Entity(name="BonExamen")
@Table(name="bon_examen")
public class BonExamen {
    @Id
    @GeneratedValue
    private Long id;
    private String salle;
    @Column(name="renseignement_clinique")
    private String renseignementClinique;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @OneToOne(mappedBy="bonExamen")
    private Facture facture;
    @OneToOne
    @JoinColumn(name="consultation_id")
    private Consultation consultation;
    @OneToMany(mappedBy="bonExamen", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Examen> examens = new ArrayList<Examen>();
    @ManyToOne
    @JoinColumn(name="service_id")
    private Service service;
    @ManyToOne
    @JoinColumn(name="dossier_medical_id")
    private DossierMedical dossierMedical;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public void setExamens(List<Examen> examens) {
        if (examens != null) {
            this.examens.clear();
            for (Examen examen : examens) {
                examen.setBonExamen(this);
                this.getExamens().add(examen);
            }
        }
    }

    public BonExamen(Long id, String salle, String renseignementClinique, Date dateCreation, Date dateModification, Facture facture, Consultation consultation, List<Examen> examens, Service service, DossierMedical dossierMedical) {
        this.id = id;
        this.salle = salle;
        this.renseignementClinique = renseignementClinique;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.facture = facture;
        this.consultation = consultation;
        this.examens = examens;
        this.service = service;
        this.dossierMedical = dossierMedical;
    }

    public BonExamen() {
    }

    public Long getId() {
        return this.id;
    }

    public String getSalle() {
        return this.salle;
    }

    public String getRenseignementClinique() {
        return this.renseignementClinique;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Facture getFacture() {
        return this.facture;
    }

    public Consultation getConsultation() {
        return this.consultation;
    }

    public List<Examen> getExamens() {
        return this.examens;
    }

    public Service getService() {
        return this.service;
    }

    public DossierMedical getDossierMedical() {
        return this.dossierMedical;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSalle(String salle) {
        this.salle = salle;
    }

    public void setRenseignementClinique(String renseignementClinique) {
        this.renseignementClinique = renseignementClinique;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setFacture(Facture facture) {
        this.facture = facture;
    }

    public void setConsultation(Consultation consultation) {
        this.consultation = consultation;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setDossierMedical(DossierMedical dossierMedical) {
        this.dossierMedical = dossierMedical;
    }
}

