/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Ordonnance;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Service;
import org.hopeclinic.gestiondespatients.model.Symptome;
import org.hopeclinic.gestiondespatients.type.EtatOperation;

@Entity
@Table(name="consultation")
public class Consultation {
    @Id
    @GeneratedValue
    @Column(nullable=false, unique=true)
    private Long id;
    private String diagnostic;
    private String motif;
    @Column(name="lieu")
    private String lieu;
    @Column(name="prix")
    private Double prix = 0.0;
    @Column(name="part_payee_par_patient")
    private Double partPayeeParPatient = 0.0;
    @Enumerated(value=EnumType.STRING)
    private EtatOperation etat;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @OneToOne(mappedBy="consultation")
    private Facture facture;
    @JsonIgnore
    @OneToOne(mappedBy="consultation")
    private BonExamen bonExamen;
    @JsonIgnore
    @OneToOne(mappedBy="consultation")
    private Ordonnance ordonnance;
    @ManyToOne
    @JoinColumn(name="service_id")
    private Service service;
    @ManyToOne
    @JoinColumn(name="dossier_medical_id")
    private DossierMedical dossierMedical;
    @ManyToOne
    @JoinColumn(name="personnel_medical_id")
    private PersonnelMedical personnelMedical;
    @OneToMany(mappedBy="consultation", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Symptome> symptomes = new ArrayList<Symptome>();

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public void setSymptomes(List<Symptome> symptomes) {
        this.symptomes.clear();
        if (symptomes != null) {
            for (Symptome symptome : symptomes) {
                symptome.setConsultation(this);
                this.getSymptomes().add(symptome);
            }
        }
    }

    public Consultation(Long id, String diagnostic, String motif, String lieu, Double prix, Double partPayeeParPatient, EtatOperation etat, Date dateCreation, Date dateModification, Facture facture, BonExamen bonExamen, Ordonnance ordonnance, Service service, DossierMedical dossierMedical, PersonnelMedical personnelMedical, List<Symptome> symptomes) {
        this.id = id;
        this.diagnostic = diagnostic;
        this.motif = motif;
        this.lieu = lieu;
        this.prix = prix;
        this.partPayeeParPatient = partPayeeParPatient;
        this.etat = etat;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.facture = facture;
        this.bonExamen = bonExamen;
        this.ordonnance = ordonnance;
        this.service = service;
        this.dossierMedical = dossierMedical;
        this.personnelMedical = personnelMedical;
        this.symptomes = symptomes;
    }

    public Consultation() {
    }

    public Long getId() {
        return this.id;
    }

    public String getDiagnostic() {
        return this.diagnostic;
    }

    public String getMotif() {
        return this.motif;
    }

    public String getLieu() {
        return this.lieu;
    }

    public Double getPrix() {
        return this.prix;
    }

    public Double getPartPayeeParPatient() {
        return this.partPayeeParPatient;
    }

    public EtatOperation getEtat() {
        return this.etat;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Facture getFacture() {
        return this.facture;
    }

    public BonExamen getBonExamen() {
        return this.bonExamen;
    }

    public Ordonnance getOrdonnance() {
        return this.ordonnance;
    }

    public Service getService() {
        return this.service;
    }

    public DossierMedical getDossierMedical() {
        return this.dossierMedical;
    }

    public PersonnelMedical getPersonnelMedical() {
        return this.personnelMedical;
    }

    public List<Symptome> getSymptomes() {
        return this.symptomes;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDiagnostic(String diagnostic) {
        this.diagnostic = diagnostic;
    }

    public void setMotif(String motif) {
        this.motif = motif;
    }

    public void setLieu(String lieu) {
        this.lieu = lieu;
    }

    public void setPrix(Double prix) {
        this.prix = prix;
    }

    public void setPartPayeeParPatient(Double partPayeeParPatient) {
        this.partPayeeParPatient = partPayeeParPatient;
    }

    public void setEtat(EtatOperation etat) {
        this.etat = etat;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setFacture(Facture facture) {
        this.facture = facture;
    }

    @JsonIgnore
    public void setBonExamen(BonExamen bonExamen) {
        this.bonExamen = bonExamen;
    }

    @JsonIgnore
    public void setOrdonnance(Ordonnance ordonnance) {
        this.ordonnance = ordonnance;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setDossierMedical(DossierMedical dossierMedical) {
        this.dossierMedical = dossierMedical;
    }

    public void setPersonnelMedical(PersonnelMedical personnelMedical) {
        this.personnelMedical = personnelMedical;
    }
}

