/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hopeclinic.gestiondespatients.model.Antecedent;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Ordonnance;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.model.Soin;

@Entity(name="DossierMedicalComponent")
@Table(name="dossier_medical")
public class DossierMedical {
    @Id
    @GeneratedValue
    @Column(nullable=false, unique=true)
    private Long id;
    @Column(name="groupe_sanguin")
    private String groupeSanguin;
    @Column(name="electrophorese")
    private String electrophorese;
    @Column(name="date_creation")
    private Date dateCreation;
    @Column(name="date_modification")
    private Date dateModification;
    @OneToOne
    @JoinColumn(name="patient_id", nullable=false)
    private Patient patient;
    @JsonIgnore
    @OneToMany(mappedBy="dossierMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Consultation> consultations = new ArrayList<Consultation>();
    @OneToMany(mappedBy="dossierMedical", orphanRemoval=true, cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private List<Antecedent> antecedents = new ArrayList<Antecedent>();
    @JsonIgnore
    @OneToMany(mappedBy="dossierMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Soin> soins = new ArrayList<Soin>();
    @JsonIgnore
    @OneToMany(mappedBy="dossierMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BonExamen> bonsExamens = new ArrayList<BonExamen>();
    @JsonIgnore
    @OneToMany(mappedBy="dossierMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Ordonnance> ordonnances = new ArrayList<Ordonnance>();

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public void setAntecedents(List<Antecedent> antecedents) {
        this.antecedents.clear();
        if (antecedents != null) {
            for (Antecedent antecedent : antecedents) {
                antecedent.setDossierMedical(this);
                this.getAntecedents().add(antecedent);
            }
        }
    }

    public DossierMedical(Long id, String groupeSanguin, String electrophorese, Date dateCreation, Date dateModification, Patient patient, List<Consultation> consultations, List<Antecedent> antecedents, List<Soin> soins, List<BonExamen> bonsExamens, List<Ordonnance> ordonnances) {
        this.id = id;
        this.groupeSanguin = groupeSanguin;
        this.electrophorese = electrophorese;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.patient = patient;
        this.consultations = consultations;
        this.antecedents = antecedents;
        this.soins = soins;
        this.bonsExamens = bonsExamens;
        this.ordonnances = ordonnances;
    }

    public DossierMedical() {
    }

    public Long getId() {
        return this.id;
    }

    public String getGroupeSanguin() {
        return this.groupeSanguin;
    }

    public String getElectrophorese() {
        return this.electrophorese;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public List<Consultation> getConsultations() {
        return this.consultations;
    }

    public List<Antecedent> getAntecedents() {
        return this.antecedents;
    }

    public List<Soin> getSoins() {
        return this.soins;
    }

    public List<BonExamen> getBonsExamens() {
        return this.bonsExamens;
    }

    public List<Ordonnance> getOrdonnances() {
        return this.ordonnances;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGroupeSanguin(String groupeSanguin) {
        this.groupeSanguin = groupeSanguin;
    }

    public void setElectrophorese(String electrophorese) {
        this.electrophorese = electrophorese;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    @JsonIgnore
    public void setConsultations(List<Consultation> consultations) {
        this.consultations = consultations;
    }

    @JsonIgnore
    public void setSoins(List<Soin> soins) {
        this.soins = soins;
    }

    @JsonIgnore
    public void setBonsExamens(List<BonExamen> bonsExamens) {
        this.bonsExamens = bonsExamens;
    }

    @JsonIgnore
    public void setOrdonnances(List<Ordonnance> ordonnances) {
        this.ordonnances = ordonnances;
    }
}

