/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Hospitalisation;
import org.hopeclinic.gestiondespatients.model.TypeExamen;

@Entity
@Table(name="examen")
public class Examen {
    @Id
    @GeneratedValue
    private Long id;
    private String nom;
    private String resultat;
    @Column(name="prise_en_charge_structure")
    private Boolean priseEnChargeStructure;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="hospitalisation_id")
    private Hospitalisation hospitalisation;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="bon_examen_id")
    private BonExamen bonExamen;
    @ManyToOne
    @JoinColumn(name="type_examen_id")
    private TypeExamen typeExamen;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Examen(Long id, String nom, String resultat, Boolean priseEnChargeStructure, Date dateCreation, Date dateModification, Hospitalisation hospitalisation, BonExamen bonExamen, TypeExamen typeExamen) {
        this.id = id;
        this.nom = nom;
        this.resultat = resultat;
        this.priseEnChargeStructure = priseEnChargeStructure;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.hospitalisation = hospitalisation;
        this.bonExamen = bonExamen;
        this.typeExamen = typeExamen;
    }

    public Examen() {
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public String getResultat() {
        return this.resultat;
    }

    public Boolean getPriseEnChargeStructure() {
        return this.priseEnChargeStructure;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Hospitalisation getHospitalisation() {
        return this.hospitalisation;
    }

    public BonExamen getBonExamen() {
        return this.bonExamen;
    }

    public TypeExamen getTypeExamen() {
        return this.typeExamen;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setResultat(String resultat) {
        this.resultat = resultat;
    }

    public void setPriseEnChargeStructure(Boolean priseEnChargeStructure) {
        this.priseEnChargeStructure = priseEnChargeStructure;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setHospitalisation(Hospitalisation hospitalisation) {
        this.hospitalisation = hospitalisation;
    }

    @JsonIgnore
    public void setBonExamen(BonExamen bonExamen) {
        this.bonExamen = bonExamen;
    }

    public void setTypeExamen(TypeExamen typeExamen) {
        this.typeExamen = typeExamen;
    }
}

