/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hopeclinic.gestiondespatients.model.Assurance;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Hospitalisation;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.model.Recu;
import org.hopeclinic.gestiondespatients.model.Soin;
import org.hopeclinic.gestiondespatients.type.EtatFacture;

@Entity
@Table(name="facture")
public class Facture {
    @Id
    @GeneratedValue
    private Long id;
    private String reference;
    @Column(name="montant_total")
    private Double montantTotal;
    @Column(name="reduction_appliquee")
    private Boolean reductionAppliquee;
    @Column(name="pourcentage_reduction")
    private Integer pourcentageReduction;
    @Column(name="part_payee_assurance")
    private Double partPayeeAssurance;
    @Column(name="part_payee_patient")
    private Double partPayeePatient;
    @Column(name="reste_a_payer")
    private Double resteAPayer;
    @Enumerated(value=EnumType.STRING)
    private EtatFacture etat;
    @Column(name="date_creation")
    private Date dateCreation;
    @Column(name="date_modification")
    private Date dateModification;
    @JsonIgnore
    @OneToOne
    @JoinColumn(name="consultation_id")
    private Consultation consultation;
    @JsonIgnore
    @OneToOne
    @JoinColumn(name="hospitalisation_id")
    private Hospitalisation hospitalisation;
    @JsonIgnore
    @OneToOne
    @JoinColumn(name="bon_examen_id")
    private BonExamen bonExamen;
    @JsonIgnore
    @OneToMany(mappedBy="facture", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Soin> soins = new ArrayList<Soin>();
    @JsonIgnore
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="recu_id")
    private Recu recu;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="assurance_id")
    private Assurance assurance;
    @ManyToOne
    @JoinColumn(name="patient_id")
    private Patient patient;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    @PostLoad
    private void onLoad() {
        this.totalPrice();
        this.totalPartPayeePatient();
    }

    protected void totalPrice() {
        double soinTotalPrice = 0.0;
        double hospiPrice = 0.0;
        double consultPrice = 0.0;
        if (this.soins != null) {
            for (Soin soin : this.soins) {
                if (soin == null) continue;
                soinTotalPrice += soin.getTypeSoin() == null ? 0.0 : soin.getTypeSoin().getPrix();
            }
        }
        if (this.hospitalisation != null) {
            double d = hospiPrice = this.hospitalisation.getPrixChambre() == null ? 0.0 : this.hospitalisation.getPrixChambre();
        }
        if (this.consultation != null) {
            consultPrice = this.consultation.getPrix() == null ? 0.0 : this.consultation.getPrix();
        }
        this.montantTotal = hospiPrice + soinTotalPrice + consultPrice;
    }

    protected void totalPartPayeePatient() {
        double soinTotalPrice = 0.0;
        double hospiPrice = 0.0;
        double consultPrice = 0.0;
        if (this.soins != null) {
            for (Soin soin : this.soins) {
                if (soin == null) continue;
                soinTotalPrice += soin.getPartPayee() == null ? 0.0 : soin.getPartPayee();
            }
        }
        if (this.hospitalisation != null) {
            double d = hospiPrice = this.hospitalisation.getPartPayee() == null ? 0.0 : this.hospitalisation.getPartPayee();
        }
        if (this.consultation != null) {
            consultPrice = this.consultation.getPartPayeeParPatient() == null ? 0.0 : this.consultation.getPartPayeeParPatient();
        }
        this.partPayeePatient = hospiPrice + soinTotalPrice + consultPrice;
    }

    public Facture(Long id, String reference, Double montantTotal, Boolean reductionAppliquee, Integer pourcentageReduction, Double partPayeeAssurance, Double partPayeePatient, Double resteAPayer, EtatFacture etat, Date dateCreation, Date dateModification, Consultation consultation, Hospitalisation hospitalisation, BonExamen bonExamen, List<Soin> soins, Recu recu, Assurance assurance, Patient patient) {
        this.id = id;
        this.reference = reference;
        this.montantTotal = montantTotal;
        this.reductionAppliquee = reductionAppliquee;
        this.pourcentageReduction = pourcentageReduction;
        this.partPayeeAssurance = partPayeeAssurance;
        this.partPayeePatient = partPayeePatient;
        this.resteAPayer = resteAPayer;
        this.etat = etat;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.consultation = consultation;
        this.hospitalisation = hospitalisation;
        this.bonExamen = bonExamen;
        this.soins = soins;
        this.recu = recu;
        this.assurance = assurance;
        this.patient = patient;
    }

    public Facture() {
    }

    public Long getId() {
        return this.id;
    }

    public String getReference() {
        return this.reference;
    }

    public Double getMontantTotal() {
        return this.montantTotal;
    }

    public Boolean getReductionAppliquee() {
        return this.reductionAppliquee;
    }

    public Integer getPourcentageReduction() {
        return this.pourcentageReduction;
    }

    public Double getPartPayeeAssurance() {
        return this.partPayeeAssurance;
    }

    public Double getPartPayeePatient() {
        return this.partPayeePatient;
    }

    public Double getResteAPayer() {
        return this.resteAPayer;
    }

    public EtatFacture getEtat() {
        return this.etat;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Consultation getConsultation() {
        return this.consultation;
    }

    public Hospitalisation getHospitalisation() {
        return this.hospitalisation;
    }

    public BonExamen getBonExamen() {
        return this.bonExamen;
    }

    public List<Soin> getSoins() {
        return this.soins;
    }

    public Recu getRecu() {
        return this.recu;
    }

    public Assurance getAssurance() {
        return this.assurance;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void setMontantTotal(Double montantTotal) {
        this.montantTotal = montantTotal;
    }

    public void setReductionAppliquee(Boolean reductionAppliquee) {
        this.reductionAppliquee = reductionAppliquee;
    }

    public void setPourcentageReduction(Integer pourcentageReduction) {
        this.pourcentageReduction = pourcentageReduction;
    }

    public void setPartPayeeAssurance(Double partPayeeAssurance) {
        this.partPayeeAssurance = partPayeeAssurance;
    }

    public void setPartPayeePatient(Double partPayeePatient) {
        this.partPayeePatient = partPayeePatient;
    }

    public void setResteAPayer(Double resteAPayer) {
        this.resteAPayer = resteAPayer;
    }

    public void setEtat(EtatFacture etat) {
        this.etat = etat;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setConsultation(Consultation consultation) {
        this.consultation = consultation;
    }

    @JsonIgnore
    public void setHospitalisation(Hospitalisation hospitalisation) {
        this.hospitalisation = hospitalisation;
    }

    @JsonIgnore
    public void setBonExamen(BonExamen bonExamen) {
        this.bonExamen = bonExamen;
    }

    @JsonIgnore
    public void setSoins(List<Soin> soins) {
        this.soins = soins;
    }

    @JsonIgnore
    public void setRecu(Recu recu) {
        this.recu = recu;
    }

    @JsonIgnore
    public void setAssurance(Assurance assurance) {
        this.assurance = assurance;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }
}

