/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Acte;
import org.hopeclinic.gestiondespatients.model.Chambre;
import org.hopeclinic.gestiondespatients.model.Examen;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Patient;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;

@Entity
@Table(name="hospitalisation")
public class Hospitalisation {
    @Id
    @GeneratedValue
    private Long id;
    private String observation;
    @Column(name="part_payee")
    private Double partPayee;
    @Column(name="date_entree")
    private Date dateEntree;
    @Column(name="date_sortie")
    private Date dateSortie;
    @Column(name="prix_chambre")
    private Double prixChambre = 0.0;
    @Column(name="nb_jour")
    private int nbJour;
    @Column(name="nb_passage_medecin")
    private int nbPassageMedecin;
    @Column(name="nb_passage_medecin_specialiste")
    private int nbPassageMedecinSpecialiste;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @OneToOne(mappedBy="hospitalisation", orphanRemoval=true, cascade={CascadeType.ALL})
    private Facture facture;
    @JsonIgnore
    @OneToMany(mappedBy="hospitalisation", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Examen> examens;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="patient_id")
    private Patient patient;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="medecin_traitant_id")
    private PersonnelMedical personnelMedical;
    @JsonIgnore
    @OneToMany(mappedBy="hospitalisation", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Acte> actes = new ArrayList<Acte>();
    @ManyToOne
    @JoinColumn(name="chambre_id")
    private Chambre chambre;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Hospitalisation(Long id, String observation, Double partPayee, Date dateEntree, Date dateSortie, Double prixChambre, int nbJour, int nbPassageMedecin, int nbPassageMedecinSpecialiste, Date dateCreation, Date dateModification, Facture facture, List<Examen> examens, Patient patient, PersonnelMedical personnelMedical, List<Acte> actes, Chambre chambre) {
        this.id = id;
        this.observation = observation;
        this.partPayee = partPayee;
        this.dateEntree = dateEntree;
        this.dateSortie = dateSortie;
        this.prixChambre = prixChambre;
        this.nbJour = nbJour;
        this.nbPassageMedecin = nbPassageMedecin;
        this.nbPassageMedecinSpecialiste = nbPassageMedecinSpecialiste;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.facture = facture;
        this.examens = examens;
        this.patient = patient;
        this.personnelMedical = personnelMedical;
        this.actes = actes;
        this.chambre = chambre;
    }

    public Hospitalisation() {
    }

    public Long getId() {
        return this.id;
    }

    public String getObservation() {
        return this.observation;
    }

    public Double getPartPayee() {
        return this.partPayee;
    }

    public Date getDateEntree() {
        return this.dateEntree;
    }

    public Date getDateSortie() {
        return this.dateSortie;
    }

    public Double getPrixChambre() {
        return this.prixChambre;
    }

    public int getNbJour() {
        return this.nbJour;
    }

    public int getNbPassageMedecin() {
        return this.nbPassageMedecin;
    }

    public int getNbPassageMedecinSpecialiste() {
        return this.nbPassageMedecinSpecialiste;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Facture getFacture() {
        return this.facture;
    }

    public List<Examen> getExamens() {
        return this.examens;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public PersonnelMedical getPersonnelMedical() {
        return this.personnelMedical;
    }

    public List<Acte> getActes() {
        return this.actes;
    }

    public Chambre getChambre() {
        return this.chambre;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setObservation(String observation) {
        this.observation = observation;
    }

    public void setPartPayee(Double partPayee) {
        this.partPayee = partPayee;
    }

    public void setDateEntree(Date dateEntree) {
        this.dateEntree = dateEntree;
    }

    public void setDateSortie(Date dateSortie) {
        this.dateSortie = dateSortie;
    }

    public void setPrixChambre(Double prixChambre) {
        this.prixChambre = prixChambre;
    }

    public void setNbJour(int nbJour) {
        this.nbJour = nbJour;
    }

    public void setNbPassageMedecin(int nbPassageMedecin) {
        this.nbPassageMedecin = nbPassageMedecin;
    }

    public void setNbPassageMedecinSpecialiste(int nbPassageMedecinSpecialiste) {
        this.nbPassageMedecinSpecialiste = nbPassageMedecinSpecialiste;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setFacture(Facture facture) {
        this.facture = facture;
    }

    @JsonIgnore
    public void setExamens(List<Examen> examens) {
        this.examens = examens;
    }

    @JsonIgnore
    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    @JsonIgnore
    public void setPersonnelMedical(PersonnelMedical personnelMedical) {
        this.personnelMedical = personnelMedical;
    }

    @JsonIgnore
    public void setActes(List<Acte> actes) {
        this.actes = actes;
    }

    public void setChambre(Chambre chambre) {
        this.chambre = chambre;
    }
}

