/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Prescription;
import org.hopeclinic.gestiondespatients.model.Service;

@Entity
@Table(name="ordonnance")
public class Ordonnance {
    @Id
    @GeneratedValue
    private Long id;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @OneToMany(mappedBy="ordonnance", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Prescription> prescriptions = new ArrayList<Prescription>();
    @OneToOne
    @JoinColumn(name="consultation_id")
    private Consultation consultation;
    @ManyToOne
    @JoinColumn(name="service_id")
    private Service service;
    @ManyToOne
    @JoinColumn(name="dossier_medical_id")
    private DossierMedical dossierMedical;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public void setPrescriptions(List<Prescription> prescriptions) {
        this.prescriptions.clear();
        if (prescriptions != null) {
            for (Prescription prescription : prescriptions) {
                prescription.setOrdonnance(this);
                this.getPrescriptions().add(prescription);
            }
        }
    }

    public Ordonnance(Long id, Date dateCreation, Date dateModification, List<Prescription> prescriptions, Consultation consultation, Service service, DossierMedical dossierMedical) {
        this.id = id;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.prescriptions = prescriptions;
        this.consultation = consultation;
        this.service = service;
        this.dossierMedical = dossierMedical;
    }

    public Ordonnance() {
    }

    public Long getId() {
        return this.id;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public List<Prescription> getPrescriptions() {
        return this.prescriptions;
    }

    public Consultation getConsultation() {
        return this.consultation;
    }

    public Service getService() {
        return this.service;
    }

    public DossierMedical getDossierMedical() {
        return this.dossierMedical;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    public void setConsultation(Consultation consultation) {
        this.consultation = consultation;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setDossierMedical(DossierMedical dossierMedical) {
        this.dossierMedical = dossierMedical;
    }
}

