/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.hopeclinic.gestiondespatients.model.Assurance;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Recu;
import org.hopeclinic.gestiondespatients.model.Utilisateur;

@Entity
@Table(name="patient")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class Patient
extends Utilisateur {
    @Column
    private String fonction;
    @Column(name="personne_a_contacter")
    private String personneAContacter;
    @Column(name="fonction_personne")
    private String fonctionPersonne;
    @Column(name="lien_parente")
    private String lienParente;
    @Column(name="contact_personne")
    private String contactPersonne;
    @Column(name="adresse_personne")
    private String adressePersonne;
    @JsonIgnore
    @OneToOne(mappedBy="patient", orphanRemoval=true, cascade={CascadeType.ALL})
    private DossierMedical dossierMedical;
    @JsonIgnore
    @ManyToMany(mappedBy="patients", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<Assurance> assurances = new ArrayList<Assurance>();
    @JsonIgnore
    @OneToMany(mappedBy="patient", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Facture> factures = new ArrayList<Facture>();
    @JsonIgnore
    @OneToMany(mappedBy="patient", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Recu> recus = new ArrayList<Recu>();

    public Patient(Long id, String username, String nom, String prenom, String sexe, Date dateDeNaissance, String adresse, String contact, String fonction, String email, String motDePasse, String personneAContacter, String lienParente, String fonctionPersonne, String contactPersonne, String adressePersonne, Date dateCreation, Date dateModification, DossierMedical dossierMedical, List<Assurance> assurances) {
        super(id, nom, username, prenom, adresse, sexe, dateDeNaissance, contact, email, motDePasse, dateCreation, dateModification);
        this.fonction = fonction;
        this.personneAContacter = personneAContacter;
        this.fonctionPersonne = fonctionPersonne;
        this.lienParente = lienParente;
        this.contactPersonne = contactPersonne;
        this.adressePersonne = adressePersonne;
        this.dossierMedical = dossierMedical;
        this.assurances = assurances;
    }

    public Patient() {
    }

    public String getFonction() {
        return this.fonction;
    }

    public String getPersonneAContacter() {
        return this.personneAContacter;
    }

    public String getFonctionPersonne() {
        return this.fonctionPersonne;
    }

    public String getLienParente() {
        return this.lienParente;
    }

    public String getContactPersonne() {
        return this.contactPersonne;
    }

    public String getAdressePersonne() {
        return this.adressePersonne;
    }

    public DossierMedical getDossierMedical() {
        return this.dossierMedical;
    }

    public List<Assurance> getAssurances() {
        return this.assurances;
    }

    public List<Facture> getFactures() {
        return this.factures;
    }

    public List<Recu> getRecus() {
        return this.recus;
    }

    public void setFonction(String fonction) {
        this.fonction = fonction;
    }

    public void setPersonneAContacter(String personneAContacter) {
        this.personneAContacter = personneAContacter;
    }

    public void setFonctionPersonne(String fonctionPersonne) {
        this.fonctionPersonne = fonctionPersonne;
    }

    public void setLienParente(String lienParente) {
        this.lienParente = lienParente;
    }

    public void setContactPersonne(String contactPersonne) {
        this.contactPersonne = contactPersonne;
    }

    public void setAdressePersonne(String adressePersonne) {
        this.adressePersonne = adressePersonne;
    }

    @JsonIgnore
    public void setDossierMedical(DossierMedical dossierMedical) {
        this.dossierMedical = dossierMedical;
    }

    @JsonIgnore
    public void setAssurances(List<Assurance> assurances) {
        this.assurances = assurances;
    }

    @JsonIgnore
    public void setFactures(List<Facture> factures) {
        this.factures = factures;
    }

    @JsonIgnore
    public void setRecus(List<Recu> recus) {
        this.recus = recus;
    }
}

