/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hopeclinic.gestiondespatients.model.Acte;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Hospitalisation;
import org.hopeclinic.gestiondespatients.model.Rdv;
import org.hopeclinic.gestiondespatients.model.Role;
import org.hopeclinic.gestiondespatients.model.Service;
import org.hopeclinic.gestiondespatients.model.Soin;
import org.hopeclinic.gestiondespatients.model.Utilisateur;

@Entity
@Table(name="personnel_medical")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
@JsonIgnoreProperties(value={"motDePasse"})
public class PersonnelMedical
extends Utilisateur {
    @JsonIgnore
    @OneToMany(mappedBy="personnelMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Soin> soins = new ArrayList<Soin>();
    @JsonIgnore
    @OneToMany(mappedBy="personnelMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Hospitalisation> hospitalisations = new ArrayList<Hospitalisation>();
    @ManyToOne
    @JoinColumn(name="role_id", nullable=false)
    private Role role;
    @ManyToOne
    @JoinColumn(name="service_id")
    private Service service;
    @JsonIgnore
    @OneToMany(mappedBy="personnelMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Acte> actes = new ArrayList<Acte>();
    @JsonIgnore
    @OneToMany(mappedBy="personnelMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Rdv> rdv = new ArrayList<Rdv>();
    @JsonIgnore
    @OneToMany(mappedBy="personnelMedical", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Consultation> consultations = new ArrayList<Consultation>();

    public PersonnelMedical(Long id, String username, String nom, String prenom, String sexe, Date dateDeNaissance, String adresse, String contact, String email, String motDePasse, Date dateCreation, Date dateModification, List<Soin> soins, List<Hospitalisation> hospitalisations, Role role, Service service, List<Consultation> consultations, List<Acte> actes, List<Rdv> rdv) {
        super(id, nom, username, prenom, adresse, sexe, dateDeNaissance, contact, email, motDePasse, dateCreation, dateModification);
        this.role = role;
        this.service = service;
        this.soins = soins;
        this.consultations = consultations;
        this.hospitalisations = hospitalisations;
        this.actes = actes;
        this.rdv = rdv;
    }

    public PersonnelMedical() {
    }

    public List<Soin> getSoins() {
        return this.soins;
    }

    public List<Hospitalisation> getHospitalisations() {
        return this.hospitalisations;
    }

    public Role getRole() {
        return this.role;
    }

    public Service getService() {
        return this.service;
    }

    public List<Acte> getActes() {
        return this.actes;
    }

    public List<Rdv> getRdv() {
        return this.rdv;
    }

    public List<Consultation> getConsultations() {
        return this.consultations;
    }

    @JsonIgnore
    public void setSoins(List<Soin> soins) {
        this.soins = soins;
    }

    @JsonIgnore
    public void setHospitalisations(List<Hospitalisation> hospitalisations) {
        this.hospitalisations = hospitalisations;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public void setService(Service service) {
        this.service = service;
    }

    @JsonIgnore
    public void setActes(List<Acte> actes) {
        this.actes = actes;
    }

    @JsonIgnore
    public void setRdv(List<Rdv> rdv) {
        this.rdv = rdv;
    }

    @JsonIgnore
    public void setConsultations(List<Consultation> consultations) {
        this.consultations = consultations;
    }
}

