/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Ordonnance;

@Entity
@Table(name="prescription")
public class Prescription {
    @Id
    @GeneratedValue
    private Long id;
    private String medicament;
    private String dose;
    @Column(name="nb_prise_par_jour")
    private String nbPriseParJour;
    @Column(name="duree_traitement")
    private String dureeTraitement;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="ordonnance_id")
    private Ordonnance ordonnance;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Prescription(Long id, String medicament, String dose, String nbPriseParJour, String dureeTraitement, Date dateCreation, Date dateModification, Ordonnance ordonnance) {
        this.id = id;
        this.medicament = medicament;
        this.dose = dose;
        this.nbPriseParJour = nbPriseParJour;
        this.dureeTraitement = dureeTraitement;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.ordonnance = ordonnance;
    }

    public Prescription() {
    }

    public Long getId() {
        return this.id;
    }

    public String getMedicament() {
        return this.medicament;
    }

    public String getDose() {
        return this.dose;
    }

    public String getNbPriseParJour() {
        return this.nbPriseParJour;
    }

    public String getDureeTraitement() {
        return this.dureeTraitement;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Ordonnance getOrdonnance() {
        return this.ordonnance;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMedicament(String medicament) {
        this.medicament = medicament;
    }

    public void setDose(String dose) {
        this.dose = dose;
    }

    public void setNbPriseParJour(String nbPriseParJour) {
        this.nbPriseParJour = nbPriseParJour;
    }

    public void setDureeTraitement(String dureeTraitement) {
        this.dureeTraitement = dureeTraitement;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setOrdonnance(Ordonnance ordonnance) {
        this.ordonnance = ordonnance;
    }
}

