/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Service;
import org.hopeclinic.gestiondespatients.type.EtatOperation;

@Entity
@Table(name="rdv")
public class Rdv {
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private String patient;
    @Column
    private String contact;
    @Column
    private String sexe;
    @Column
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date date;
    @Column
    private String heure;
    @Enumerated(value=EnumType.STRING)
    @Column(name="etat")
    private EtatOperation etat;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @ManyToOne
    @JoinColumn(name="personnel_medical_id")
    private PersonnelMedical personnelMedical;
    @ManyToOne
    @JoinColumn(name="service_id")
    private Service service;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Rdv(Long id, String patient, String contact, String sexe, Date date, String heure, EtatOperation etat, Date dateCreation, Date dateModification, PersonnelMedical personnelMedical, Service service) {
        this.id = id;
        this.patient = patient;
        this.contact = contact;
        this.sexe = sexe;
        this.date = date;
        this.heure = heure;
        this.etat = etat;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.personnelMedical = personnelMedical;
        this.service = service;
    }

    public Rdv() {
    }

    public Long getId() {
        return this.id;
    }

    public String getPatient() {
        return this.patient;
    }

    public String getContact() {
        return this.contact;
    }

    public String getSexe() {
        return this.sexe;
    }

    public Date getDate() {
        return this.date;
    }

    public String getHeure() {
        return this.heure;
    }

    public EtatOperation getEtat() {
        return this.etat;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public PersonnelMedical getPersonnelMedical() {
        return this.personnelMedical;
    }

    public Service getService() {
        return this.service;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPatient(String patient) {
        this.patient = patient;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public void setSexe(String sexe) {
        this.sexe = sexe;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setHeure(String heure) {
        this.heure = heure;
    }

    public void setEtat(EtatOperation etat) {
        this.etat = etat;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    public void setPersonnelMedical(PersonnelMedical personnelMedical) {
        this.personnelMedical = personnelMedical;
    }

    public void setService(Service service) {
        this.service = service;
    }
}

