/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.Patient;

@Entity
@Table(name="recu")
public class Recu {
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private Double montant;
    @Column
    private String motif;
    @Column
    private String lieu;
    @Column(name="date_payement")
    private Date datePayment;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @OneToOne(mappedBy="recu")
    private Facture facture;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="patient_id")
    private Patient patient;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Recu(Long id, Double montant, String motif, String lieu, Date datePayment, Date dateCreation, Date dateModification, Facture facture, Patient patient) {
        this.id = id;
        this.montant = montant;
        this.motif = motif;
        this.lieu = lieu;
        this.datePayment = datePayment;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.facture = facture;
        this.patient = patient;
    }

    public Recu() {
    }

    public Long getId() {
        return this.id;
    }

    public Double getMontant() {
        return this.montant;
    }

    public String getMotif() {
        return this.motif;
    }

    public String getLieu() {
        return this.lieu;
    }

    public Date getDatePayment() {
        return this.datePayment;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Facture getFacture() {
        return this.facture;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMontant(Double montant) {
        this.montant = montant;
    }

    public void setMotif(String motif) {
        this.motif = motif;
    }

    public void setLieu(String lieu) {
        this.lieu = lieu;
    }

    public void setDatePayment(Date datePayment) {
        this.datePayment = datePayment;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    public void setFacture(Facture facture) {
        this.facture = facture;
    }

    @JsonIgnore
    public void setPatient(Patient patient) {
        this.patient = patient;
    }
}

