/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;

@Entity
@Table(name="role")
public class Role {
    @Id
    @GeneratedValue
    private Long id;
    @Column(unique=true)
    private String nom;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @OneToMany(mappedBy="role", cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private List<PersonnelMedical> personnels = new ArrayList<PersonnelMedical>();

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Role(Long id, String nom, Date dateCreation, Date dateModification, List<PersonnelMedical> personnels) {
        this.id = id;
        this.nom = nom;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.personnels = personnels;
    }

    public Role() {
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public List<PersonnelMedical> getPersonnels() {
        return this.personnels;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setPersonnels(List<PersonnelMedical> personnels) {
        this.personnels = personnels;
    }
}

