/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Acte;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Consultation;
import org.hopeclinic.gestiondespatients.model.Ordonnance;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Rdv;
import org.hopeclinic.gestiondespatients.model.Soin;

@Entity
@Table(name="service")
public class Service {
    @Id
    @GeneratedValue
    private Long id;
    @Column(name="nom")
    private String nom;
    @Column
    private String description;
    @Column(name="prix_consultation")
    private Double prixConsultation;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @OneToMany(mappedBy="service", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Consultation> consultations = new ArrayList<Consultation>();
    @JsonIgnore
    @OneToMany(mappedBy="service", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<PersonnelMedical> personnels = new ArrayList<PersonnelMedical>();
    @JsonIgnore
    @OneToMany(mappedBy="service", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Rdv> rdv = new ArrayList<Rdv>();
    @JsonIgnore
    @OneToMany(mappedBy="service", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<BonExamen> bonsExamens = new ArrayList<BonExamen>();
    @JsonIgnore
    @OneToMany(mappedBy="service", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Soin> soins = new ArrayList<Soin>();
    @JsonIgnore
    @OneToMany(mappedBy="service", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Acte> actes = new ArrayList<Acte>();
    @JsonIgnore
    @OneToMany(mappedBy="service", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Ordonnance> ordonnances = new ArrayList<Ordonnance>();

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Service(Long id, String nom, String description, Double prixConsultation, Date dateCreation, Date dateModification, List<Consultation> consultations, List<PersonnelMedical> personnels, List<Rdv> rdv, List<BonExamen> bonsExamens, List<Soin> soins, List<Acte> actes, List<Ordonnance> ordonnances) {
        this.id = id;
        this.nom = nom;
        this.description = description;
        this.prixConsultation = prixConsultation;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.consultations = consultations;
        this.personnels = personnels;
        this.rdv = rdv;
        this.bonsExamens = bonsExamens;
        this.soins = soins;
        this.actes = actes;
        this.ordonnances = ordonnances;
    }

    public Service() {
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getPrixConsultation() {
        return this.prixConsultation;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public List<Consultation> getConsultations() {
        return this.consultations;
    }

    public List<PersonnelMedical> getPersonnels() {
        return this.personnels;
    }

    public List<Rdv> getRdv() {
        return this.rdv;
    }

    public List<BonExamen> getBonsExamens() {
        return this.bonsExamens;
    }

    public List<Soin> getSoins() {
        return this.soins;
    }

    public List<Acte> getActes() {
        return this.actes;
    }

    public List<Ordonnance> getOrdonnances() {
        return this.ordonnances;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPrixConsultation(Double prixConsultation) {
        this.prixConsultation = prixConsultation;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setConsultations(List<Consultation> consultations) {
        this.consultations = consultations;
    }

    @JsonIgnore
    public void setPersonnels(List<PersonnelMedical> personnels) {
        this.personnels = personnels;
    }

    @JsonIgnore
    public void setRdv(List<Rdv> rdv) {
        this.rdv = rdv;
    }

    @JsonIgnore
    public void setBonsExamens(List<BonExamen> bonsExamens) {
        this.bonsExamens = bonsExamens;
    }

    @JsonIgnore
    public void setSoins(List<Soin> soins) {
        this.soins = soins;
    }

    @JsonIgnore
    public void setActes(List<Acte> actes) {
        this.actes = actes;
    }

    @JsonIgnore
    public void setOrdonnances(List<Ordonnance> ordonnances) {
        this.ordonnances = ordonnances;
    }
}

