/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import org.hopeclinic.gestiondespatients.model.DossierMedical;
import org.hopeclinic.gestiondespatients.model.Facture;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Service;
import org.hopeclinic.gestiondespatients.model.TypeSoin;

@Entity
@Table(name="soin")
public class Soin {
    @Id
    @GeneratedValue
    private Long id;
    private String patient;
    private String observation;
    @Column(name="part_payee")
    private Double partPayee = 0.0;
    @Column(name="date_creation")
    private Date dateCreation;
    @Column(name="date_modification")
    private Date dateModification;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="facture_id")
    private Facture facture;
    @ManyToOne
    @JoinColumn(name="type_soin_id")
    private TypeSoin typeSoin;
    @ManyToOne
    @JoinColumn(name="service_id")
    private Service service;
    @ManyToOne
    @JoinColumn(name="dossier_medical_id")
    private DossierMedical dossierMedical;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="personnel_medical_id")
    private PersonnelMedical personnelMedical;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Soin(Long id, String patient, String observation, Double partPayee, Date dateCreation, Date dateModification, Facture facture, TypeSoin typeSoin, Service service, DossierMedical dossierMedical, PersonnelMedical personnelMedical) {
        this.id = id;
        this.patient = patient;
        this.observation = observation;
        this.partPayee = partPayee;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.facture = facture;
        this.typeSoin = typeSoin;
        this.service = service;
        this.dossierMedical = dossierMedical;
        this.personnelMedical = personnelMedical;
    }

    public Soin() {
    }

    public Long getId() {
        return this.id;
    }

    public String getPatient() {
        return this.patient;
    }

    public String getObservation() {
        return this.observation;
    }

    public Double getPartPayee() {
        return this.partPayee;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Facture getFacture() {
        return this.facture;
    }

    public TypeSoin getTypeSoin() {
        return this.typeSoin;
    }

    public Service getService() {
        return this.service;
    }

    public DossierMedical getDossierMedical() {
        return this.dossierMedical;
    }

    public PersonnelMedical getPersonnelMedical() {
        return this.personnelMedical;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPatient(String patient) {
        this.patient = patient;
    }

    public void setObservation(String observation) {
        this.observation = observation;
    }

    public void setPartPayee(Double partPayee) {
        this.partPayee = partPayee;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setFacture(Facture facture) {
        this.facture = facture;
    }

    public void setTypeSoin(TypeSoin typeSoin) {
        this.typeSoin = typeSoin;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public void setDossierMedical(DossierMedical dossierMedical) {
        this.dossierMedical = dossierMedical;
    }

    @JsonIgnore
    public void setPersonnelMedical(PersonnelMedical personnelMedical) {
        this.personnelMedical = personnelMedical;
    }
}

