/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Consultation;

@Entity
@Table(name="symptome")
public class Symptome {
    @Id
    @GeneratedValue
    private Long id;
    private String observation;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @ManyToOne
    @JoinColumn(name="consultation_id")
    private Consultation consultation;

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public Symptome(Long id, String observation, Date dateCreation, Date dateModification, Consultation consultation) {
        this.id = id;
        this.observation = observation;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.consultation = consultation;
    }

    public Symptome() {
    }

    public Long getId() {
        return this.id;
    }

    public String getObservation() {
        return this.observation;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public Consultation getConsultation() {
        return this.consultation;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setObservation(String observation) {
        this.observation = observation;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setConsultation(Consultation consultation) {
        this.consultation = consultation;
    }
}

