/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Examen;

@Entity
@Table(name="type_examen")
public class TypeExamen {
    @Id
    @GeneratedValue
    private Long id;
    private String nom;
    private String service;
    private Double prix = 0.0;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @OneToMany(mappedBy="typeExamen", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Examen> examens = new ArrayList<Examen>();

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public TypeExamen(Long id, String nom, String service, Double prix, Date dateCreation, Date dateModification, List<Examen> examens) {
        this.id = id;
        this.nom = nom;
        this.service = service;
        this.prix = prix;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.examens = examens;
    }

    public TypeExamen() {
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public String getService() {
        return this.service;
    }

    public Double getPrix() {
        return this.prix;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public List<Examen> getExamens() {
        return this.examens;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setPrix(Double prix) {
        this.prix = prix;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setExamens(List<Examen> examens) {
        this.examens = examens;
    }
}

