/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hopeclinic.gestiondespatients.model.Soin;

@Entity
@Table(name="type_soin")
public class TypeSoin {
    @Id
    @GeneratedValue
    private Long id;
    private String nom;
    private Double prix;
    @Column(name="date_creation")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateCreation;
    @Column(name="date_modification")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date dateModification;
    @JsonIgnore
    @OneToMany(mappedBy="typeSoin", orphanRemoval=true, cascade={CascadeType.ALL})
    private List<Soin> soins = new ArrayList<Soin>();

    @PrePersist
    protected void onCreate() {
        this.dateCreation = new Date();
    }

    @PreUpdate
    protected void onUpdate() {
        this.dateModification = new Date();
    }

    public TypeSoin(Long id, String nom, Double prix, Date dateCreation, Date dateModification, List<Soin> soins) {
        this.id = id;
        this.nom = nom;
        this.prix = prix;
        this.dateCreation = dateCreation;
        this.dateModification = dateModification;
        this.soins = soins;
    }

    public TypeSoin() {
    }

    public Long getId() {
        return this.id;
    }

    public String getNom() {
        return this.nom;
    }

    public Double getPrix() {
        return this.prix;
    }

    public Date getDateCreation() {
        return this.dateCreation;
    }

    public Date getDateModification() {
        return this.dateModification;
    }

    public List<Soin> getSoins() {
        return this.soins;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public void setPrix(Double prix) {
        this.prix = prix;
    }

    public void setDateCreation(Date dateCreation) {
        this.dateCreation = dateCreation;
    }

    public void setDateModification(Date dateModification) {
        this.dateModification = dateModification;
    }

    @JsonIgnore
    public void setSoins(List<Soin> soins) {
        this.soins = soins;
    }
}

