/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.error.NotFoundException;
import org.hopeclinic.gestiondespatients.model.Acte;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.model.Service;
import org.hopeclinic.gestiondespatients.repository.ActeRepository;
import org.hopeclinic.gestiondespatients.repository.PersonnelMedicalRepository;
import org.hopeclinic.gestiondespatients.repository.ServiceRepository;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;

@org.springframework.stereotype.Service
public class ActeService {
    private final ActeRepository acteRepository;
    private final ServiceRepository serviceRepository;
    private final PersonnelMedicalRepository personnelMedicalRepository;

    public ActeService(ActeRepository acteRepository, ServiceRepository serviceRepository, PersonnelMedicalRepository personnelMedicalRepository) {
        this.acteRepository = acteRepository;
        this.serviceRepository = serviceRepository;
        this.personnelMedicalRepository = personnelMedicalRepository;
    }

    public List<Acte> getAllActes() {
        return this.acteRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<Acte> getActesByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.acteRepository);
    }

    public Long count() {
        return this.acteRepository.count();
    }

    public Acte getActeById(Long id) {
        Optional acteOptional = this.acteRepository.findById(id);
        return acteOptional.orElse(null);
    }

    public Acte createActe(Acte acte) {
        return (Acte)this.acteRepository.save(acte);
    }

    public List<Acte> createActes(List<Acte> newActes) {
        return this.acteRepository.saveAll(newActes);
    }

    public Acte updateActe(Long id, Acte updatedActe) {
        Optional acteOptional = this.acteRepository.findById(id);
        if (acteOptional.isPresent()) {
            Acte acte = (Acte)acteOptional.get();
            acte.setObservation(updatedActe.getObservation());
            return (Acte)this.acteRepository.save(acte);
        }
        return null;
    }

    public boolean deleteActe(Long id) {
        Optional acteOptional = this.acteRepository.findById(id);
        if (acteOptional.isPresent()) {
            this.acteRepository.delete((Acte)acteOptional.get());
            return true;
        }
        return false;
    }

    public List<Acte> getActesByService(Long serviceId) {
        Service service = (Service)this.serviceRepository.findById(serviceId).orElseThrow(() -> new NotFoundException("Service introuvable"));
        return this.acteRepository.findByService(service);
    }

    public List<Acte> getActesByPeriodeAndServiceAndPersonnel(Long serviceId, Long personnelId, String periode) {
        Service service = (Service)this.serviceRepository.findById(serviceId).orElseThrow(() -> new NotFoundException("Service introuvable"));
        PersonnelMedical personnelMedical = (PersonnelMedical)this.personnelMedicalRepository.findById(personnelId).orElseThrow(() -> new NotFoundException("Personnel introuvable"));
        return this.acteRepository.findByPeriodeAndService(periode, service, personnelMedical);
    }
}

