/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Antecedent;
import org.hopeclinic.gestiondespatients.repository.AntecedentRepository;
import org.springframework.stereotype.Service;

@Service
public class AntecedentService {
    private final AntecedentRepository antecedentRepository;

    public AntecedentService(AntecedentRepository antecedentRepository) {
        this.antecedentRepository = antecedentRepository;
    }

    public List<Antecedent> getAllAntecedents() {
        return this.antecedentRepository.findAll();
    }

    public Long count() {
        return this.antecedentRepository.count();
    }

    public Antecedent getAntecedentById(Long id) {
        Optional antecedentOptional = this.antecedentRepository.findById(id);
        return antecedentOptional.orElse(null);
    }

    public Antecedent createAntecedent(Antecedent antecedent) {
        return (Antecedent)this.antecedentRepository.save(antecedent);
    }

    public Antecedent updateAntecedent(Long id, Antecedent updatedAntecedent) {
        Optional antecedentOptional = this.antecedentRepository.findById(id);
        if (antecedentOptional.isPresent()) {
            Antecedent antecedent = (Antecedent)antecedentOptional.get();
            antecedent.setNom(updatedAntecedent.getNom());
            return (Antecedent)this.antecedentRepository.save(antecedent);
        }
        return null;
    }

    public boolean deleteAntecedent(Long id) {
        Optional antecedentOptional = this.antecedentRepository.findById(id);
        if (antecedentOptional.isPresent()) {
            this.antecedentRepository.delete((Antecedent)antecedentOptional.get());
            return true;
        }
        return false;
    }
}

