/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Assurance;
import org.hopeclinic.gestiondespatients.repository.AssuranceRepository;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class AssuranceService {
    private final AssuranceRepository assuranceRepository;

    public AssuranceService(AssuranceRepository assuranceRepository) {
        this.assuranceRepository = assuranceRepository;
    }

    public List<Assurance> getAllAssurances() {
        return this.assuranceRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public Long count() {
        return this.assuranceRepository.count();
    }

    public Assurance getAssuranceById(Long id) {
        Optional assuranceOptional = this.assuranceRepository.findById(id);
        return assuranceOptional.orElse(null);
    }

    public Assurance createAssurance(Assurance assurance) {
        return (Assurance)this.assuranceRepository.save(assurance);
    }

    public Assurance updateAssurance(Long id, Assurance updatedAssurance) {
        Optional assuranceOptional = this.assuranceRepository.findById(id);
        if (assuranceOptional.isPresent()) {
            Assurance assurance = (Assurance)assuranceOptional.get();
            assurance.setNom(updatedAssurance.getNom());
            assurance.setImage(updatedAssurance.getImage());
            assurance.setDescription(updatedAssurance.getDescription());
            assurance.setTaux(updatedAssurance.getTaux());
            return (Assurance)this.assuranceRepository.save(assurance);
        }
        return null;
    }

    public boolean deleteAssurance(Long id) {
        Optional assuranceOptional = this.assuranceRepository.findById(id);
        if (assuranceOptional.isPresent()) {
            this.assuranceRepository.delete((Assurance)assuranceOptional.get());
            return true;
        }
        return false;
    }
}

