/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Acte;
import org.hopeclinic.gestiondespatients.model.BonExamen;
import org.hopeclinic.gestiondespatients.model.Examen;
import org.hopeclinic.gestiondespatients.model.PersonnelMedical;
import org.hopeclinic.gestiondespatients.repository.BonExamenRepository;
import org.hopeclinic.gestiondespatients.service.ActeService;
import org.hopeclinic.gestiondespatients.utils.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class BonExamenService {
    private final BonExamenRepository bonExamenRepository;
    private final ActeService acteService;

    public BonExamenService(BonExamenRepository bonExamenRepository, ActeService acteService) {
        this.bonExamenRepository = bonExamenRepository;
        this.acteService = acteService;
    }

    public List<BonExamen> getAllBonExamens() {
        return this.bonExamenRepository.findAll(Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateCreation"}));
    }

    public List<BonExamen> getBonExamensByFilters(Map<String, Object> filters) {
        return Utils.getByFilters(filters, this.bonExamenRepository);
    }

    public Long count() {
        return this.bonExamenRepository.count();
    }

    public BonExamen getBonExamenById(Long id) {
        Optional bonExamenOptional = this.bonExamenRepository.findById(id);
        return bonExamenOptional.orElse(null);
    }

    public BonExamen createBonExamen(BonExamen bonExamen) {
        if (bonExamen.getExamens() != null) {
            ArrayList<Acte> actes = new ArrayList<Acte>();
            for (Examen examen : bonExamen.getExamens()) {
                PersonnelMedical personnelMedical = examen.getBonExamen().getConsultation() != null ? examen.getBonExamen().getConsultation().getPersonnelMedical() : (examen.getHospitalisation() != null ? examen.getHospitalisation().getPersonnelMedical() : null);
                Acte acte = new Acte(null, examen.getNom(), examen.getDateCreation(), null, personnelMedical, examen.getHospitalisation(), examen.getBonExamen().getService());
                actes.add(acte);
            }
            this.acteService.createActes(actes);
        }
        return (BonExamen)this.bonExamenRepository.save(bonExamen);
    }

    public BonExamen updateBonExamen(Long id, BonExamen updatedBonExamen) {
        Optional bonExamenOptional = this.bonExamenRepository.findById(id);
        if (bonExamenOptional.isPresent()) {
            BonExamen bonExamen = (BonExamen)bonExamenOptional.get();
            bonExamen.setSalle(updatedBonExamen.getSalle());
            bonExamen.setRenseignementClinique(updatedBonExamen.getRenseignementClinique());
            bonExamen.setExamens(updatedBonExamen.getExamens());
            return (BonExamen)this.bonExamenRepository.save(bonExamen);
        }
        return null;
    }

    public boolean deleteBonExamen(Long id) {
        Optional bonExamenOptional = this.bonExamenRepository.findById(id);
        if (bonExamenOptional.isPresent()) {
            this.bonExamenRepository.delete((BonExamen)bonExamenOptional.get());
            return true;
        }
        return false;
    }
}

