/*
 * Decompiled with CFR 0.152.
 */
package org.hopeclinic.gestiondespatients.service;

import java.util.List;
import java.util.Optional;
import org.hopeclinic.gestiondespatients.model.Chambre;
import org.hopeclinic.gestiondespatients.repository.ChambreRepository;
import org.springframework.stereotype.Service;

@Service
public class ChambreService {
    private final ChambreRepository chambreRepository;

    public ChambreService(ChambreRepository chambreRepository) {
        this.chambreRepository = chambreRepository;
    }

    public List<Chambre> getAllChambres() {
        return this.chambreRepository.findAll();
    }

    public Long count() {
        return this.chambreRepository.count();
    }

    public Chambre getChambreById(Long id) {
        Optional chambreOptional = this.chambreRepository.findById(id);
        return chambreOptional.orElse(null);
    }

    public Chambre createChambre(Chambre chambre) {
        return (Chambre)this.chambreRepository.save(chambre);
    }

    public Chambre updateChambre(Long id, Chambre updatedChambre) {
        Optional chambreOptional = this.chambreRepository.findById(id);
        if (chambreOptional.isPresent()) {
            Chambre chambre = (Chambre)chambreOptional.get();
            chambre.setNom(updatedChambre.getNom());
            chambre.setPrix(updatedChambre.getPrix());
            chambre.setNumero(updatedChambre.getNumero());
            chambre.setType(updatedChambre.getType());
            chambre.setNbLit(updatedChambre.getNbLit());
            return (Chambre)this.chambreRepository.save(chambre);
        }
        return null;
    }

    public boolean deleteChambre(Long id) {
        Optional chambreOptional = this.chambreRepository.findById(id);
        if (chambreOptional.isPresent()) {
            this.chambreRepository.delete((Chambre)chambreOptional.get());
            return true;
        }
        return false;
    }
}

